/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class OrIterator
implements SortedKeyValueIterator<Key, Value> {
    protected static final Logger log = Logger.getLogger(OrIterator.class);
    private static final Text nullText = new Text();
    private TermSource currentTerm;
    private ArrayList<TermSource> sources;
    private PriorityQueue<TermSource> sorted = new PriorityQueue(5);
    private Key topKey = null;
    private Range overallRange;
    private Collection<ByteSequence> columnFamilies;
    private boolean inclusive;
    private Text parentEndRow;

    public OrIterator() {
        this.sources = new ArrayList();
    }

    private OrIterator(OrIterator other, IteratorEnvironment env) {
        this.sources = new ArrayList();
        for (TermSource TS : other.sources) {
            this.sources.add(new TermSource((SortedKeyValueIterator<Key, Value>)TS.iter.deepCopy(env), TS.dataLocation, TS.term));
        }
    }

    protected static String getUID(Key key) {
        try {
            int idx = 0;
            String sKey = key.getColumnQualifier().toString();
            idx = sKey.lastIndexOf("\u0000");
            return sKey.substring(idx + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Text getPartition(Key key) {
        return key.getRow();
    }

    protected Text getDataLocation(Key key) {
        return key.getColumnFamily();
    }

    protected Text getTerm(Key key) {
        int idx = 0;
        String sKey = key.getColumnQualifier().toString();
        idx = sKey.indexOf("\u0000");
        return new Text(sKey.substring(0, idx));
    }

    protected Text getDocID(Key key) {
        int idx = 0;
        String sKey = key.getColumnQualifier().toString();
        idx = sKey.indexOf("\u0000");
        return new Text(sKey.substring(idx + 1));
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new OrIterator(this, env);
    }

    public void addTerm(SortedKeyValueIterator<Key, Value> source, Text term, IteratorEnvironment env) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"OI.addTerm Added source w/o family");
            log.debug((Object)("OI.addTerm term >>" + term + "<<"));
        }
        if (term == null) {
            this.sources.add(new TermSource(source, term));
        } else {
            this.sources.add(new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), term));
        }
    }

    public void addTerm(SortedKeyValueIterator<Key, Value> source, Text dataLocation, Text term, IteratorEnvironment env) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"OI.addTerm Added source ");
            log.debug((Object)("OI.addTerm family >>" + dataLocation + "<<      term >>" + term + "<<"));
        }
        if (term == null) {
            this.sources.add(new TermSource(source, dataLocation, term));
        } else {
            this.sources.add(new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), dataLocation, term));
        }
    }

    protected Key buildTopKey(TermSource TS) {
        if (TS == null || TS.topKey == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.buildTopKey New topKey >>" + new Key(TS.topKey.getRow(), TS.dataLocation, TS.docid) + "<<"));
        }
        return new Key(TS.topKey.getRow(), TS.topKey.getColumnFamily(), TS.topKey.getColumnQualifier());
    }

    public final void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.next Enter: sorted.size = " + this.sorted.size() + " currentTerm = " + (this.currentTerm == null ? "null" : "not null")));
        }
        if (this.currentTerm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OI.next currentTerm is NULL... returning");
            }
            this.topKey = null;
            return;
        }
        this.currentTerm.iter.next();
        this.advanceToMatch(this.currentTerm);
        this.currentTerm.setNew();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.next Checks (correct = 0,0,0): " + (this.currentTerm.topKey != null ? "0," : "1,") + (this.currentTerm.dataLocation != null ? "0," : "1,") + (this.currentTerm.term != null && this.currentTerm.fieldTerm != null ? Integer.valueOf(this.currentTerm.term.compareTo((BinaryComparable)this.currentTerm.fieldTerm)) : "0")));
        }
        if (this.currentTerm.topKey == null || this.currentTerm.dataLocation != null && this.currentTerm.term.compareTo((BinaryComparable)this.currentTerm.fieldTerm) != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.next removing entry:" + this.currentTerm.term));
            }
            this.currentTerm = null;
        }
        if (this.sorted.size() > 0) {
            if (this.currentTerm != null) {
                this.sorted.add(this.currentTerm);
            }
            this.currentTerm = this.sorted.poll();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.next CurrentTerm is " + (this.currentTerm == null ? "null" : this.currentTerm)));
        }
        this.topKey = this.buildTopKey(this.currentTerm);
        if (this.hasTop() && this.overallRange != null && !this.overallRange.contains(this.topKey)) {
            this.topKey = null;
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.overallRange = new Range(range);
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, overallRange: " + this.overallRange));
        }
        if (range.getEndKey() != null && range.getEndKey().getRow() != null) {
            this.parentEndRow = range.getEndKey().getRow();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.seek Entry - sources.size = " + this.sources.size()));
            log.debug((Object)("OI.seek Entry - currentTerm = " + (this.currentTerm == null ? "false" : this.currentTerm.iter.getTopKey())));
            log.debug((Object)("OI.seek Entry - Key from Range = " + (range == null ? "false" : range.getStartKey())));
        }
        if (this.sources.isEmpty()) {
            this.currentTerm = null;
            this.topKey = null;
            return;
        }
        this.columnFamilies = columnFamilies;
        this.inclusive = inclusive;
        Range newRange = range;
        Key sourceKey = null;
        Key startKey = null;
        if (range != null) {
            startKey = range.getStartKey();
        }
        this.sorted.clear();
        TermSource TS = null;
        Iterator<TermSource> iter = this.sources.iterator();
        int counter = 1;
        while (iter.hasNext()) {
            TS = iter.next();
            TS.atEnd = false;
            if (this.sources.size() == 1) {
                this.currentTerm = TS;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.seek on TS >>" + TS + "<<"));
                log.debug((Object)("OI.seek seeking source >>" + counter + "<< "));
            }
            ++counter;
            newRange = range;
            sourceKey = null;
            if (startKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.seek startKey >>" + startKey + "<<"));
                }
                sourceKey = startKey.getColumnQualifier() != null ? new Key(startKey.getRow(), TS.dataLocation == null ? nullText : TS.dataLocation, new Text((TS.term == null ? "" : TS.term + "\u0000") + range.getStartKey().getColumnQualifier())) : new Key(startKey.getRow(), TS.dataLocation == null ? nullText : TS.dataLocation, TS.term == null ? nullText : TS.term);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.seek Seeking to the key => " + sourceKey));
                }
                newRange = new Range(sourceKey, true, sourceKey.followingKey(PartialKey.ROW), false);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("OI.seek Using the range Seek() argument to seek => " + newRange));
            }
            TS.iter.seek(newRange, columnFamilies, inclusive);
            TS.setNew();
            this.advanceToMatch(TS);
            TS.setNew();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.seek sourceKey >>" + sourceKey + "<< "));
                log.debug((Object)("OI.seek topKey >>" + (TS.topKey == null ? "false" : TS.topKey) + "<< "));
                log.debug((Object)("OI.seek TS.fieldTerm == " + TS.fieldTerm));
                log.debug((Object)("OI.seek Checks (correct = 0,0,0 / 0,1,1): " + (TS.topKey != null ? "0," : "1,") + (TS.dataLocation != null ? "0," : "1,") + (TS.term != null && TS.fieldTerm != null && TS.term.compareTo((BinaryComparable)TS.fieldTerm) != 0 ? "0" : "1")));
            }
            if (TS.topKey == null || TS.dataLocation != null && TS.term.compareTo((BinaryComparable)TS.fieldTerm) != 0) continue;
            if (this.sources.size() > 0 || iter.hasNext()) {
                this.sorted.add(TS);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.seek new topKey >>" + (this.topKey == null ? "false" : this.topKey) + "<< "));
            }
            if (this.hasTop() && this.overallRange != null && !this.overallRange.contains(this.topKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("seek, topKey: " + this.topKey + " is not in the overallRange: " + this.overallRange));
                }
                this.topKey = null;
            }
            return;
        }
        this.currentTerm = this.sorted.poll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.seek currentTerm = " + this.currentTerm));
        }
        this.topKey = this.buildTopKey(this.currentTerm);
        if (this.topKey == null && log.isDebugEnabled()) {
            log.debug((Object)"OI.seek() topKey is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.seek new topKey >>" + (this.topKey == null ? "false" : this.topKey) + "<< "));
        }
        if (this.hasTop() && this.overallRange != null && !this.overallRange.contains(this.topKey)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("seek, topKey: " + this.topKey + " is not in the overallRange: " + this.overallRange));
            }
            this.topKey = null;
        }
    }

    public final Key getTopKey() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.getTopKey key >>" + this.topKey));
        }
        return this.topKey;
    }

    public final Value getTopValue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.getTopValue key >>" + this.currentTerm.iter.getTopValue()));
        }
        return (Value)this.currentTerm.iter.getTopValue();
    }

    public final boolean hasTop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.hasTop  =  " + (this.topKey == null ? "false" : "true")));
        }
        return this.topKey != null;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void advanceToMatch(TermSource TS) throws IOException {
        boolean matched = false;
        while (!matched) {
            Key seekKey;
            if (!TS.iter.hasTop()) {
                TS.topKey = null;
                return;
            }
            Key iterTopKey = (Key)TS.iter.getTopKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.advanceToMatch current topKey = " + iterTopKey));
            }
            if (this.overallRange.getEndKey() != null) {
                if (this.overallRange != null && !this.overallRange.contains((Key)TS.iter.getTopKey())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("overallRange: " + this.overallRange + " does not contain TS.iter.topKey: " + TS.iter.getTopKey()));
                        log.debug((Object)"OI.advanceToMatch at the end, returning");
                    }
                    TS.atEnd = true;
                    TS.topKey = null;
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.advanceToMatch not at the end");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"OI.advanceToMatch overallRange.getEndKey() == null");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Comparing dataLocations.");
                log.debug((Object)("OI.advanceToMatch dataLocationCompare: " + this.getDataLocation(iterTopKey) + " == " + TS.dataLocation));
            }
            int dataLocationCompare = this.getDataLocation(iterTopKey).compareTo((BinaryComparable)TS.dataLocation);
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.advanceToMatch dataLocationCompare = " + dataLocationCompare));
            }
            if (dataLocationCompare < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.advanceToMatch seek to desired dataLocation");
                }
                Key seekKey2 = new Key(iterTopKey.getRow(), TS.dataLocation, nullText);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.advanceToMatch seeking to => " + seekKey2));
                }
                TS.iter.seek(new Range(seekKey2, true, null, false), this.columnFamilies, this.inclusive);
                continue;
            }
            if (dataLocationCompare > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.advanceToMatch advanced beyond desired dataLocation, seek to next row");
                }
                Key seekKey3 = iterTopKey.followingKey(PartialKey.ROW);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.advanceToMatch seeking to => " + seekKey3));
                }
                TS.iter.seek(new Range(seekKey3, true, null, false), this.columnFamilies, this.inclusive);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.advanceToMatch termCompare: " + this.getTerm(iterTopKey) + " == " + TS.term));
            }
            int termCompare = this.getTerm(iterTopKey).compareTo((BinaryComparable)TS.term);
            if (log.isDebugEnabled()) {
                log.debug((Object)("OI.advanceToMatch termCompare = " + termCompare));
            }
            if (termCompare < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.advanceToMatch seek to desired term");
                }
                seekKey = new Key(iterTopKey.getRow(), iterTopKey.getColumnFamily(), TS.term);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.advanceToMatch seeking to => " + seekKey));
                }
                TS.iter.seek(new Range(seekKey, true, null, false), this.columnFamilies, this.inclusive);
                continue;
            }
            if (termCompare > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.advanceToMatch advanced beyond desired term, seek to next row");
                }
                seekKey = iterTopKey.followingKey(PartialKey.ROW);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.advanceToMatch seeking to => " + seekKey));
                }
                TS.iter.seek(new Range(seekKey, true, null, false), this.columnFamilies, this.inclusive);
                continue;
            }
            matched = true;
        }
    }

    public boolean jump(Key jumpKey) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OR jump: " + jumpKey));
            this.printTopKeysForTermSources();
        }
        if (this.parentEndRow != null && this.parentEndRow.compareTo((BinaryComparable)jumpKey.getRow()) < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jumpRow: " + jumpKey.getRow() + " is greater than my parentEndRow: " + this.parentEndRow));
            }
            return false;
        }
        this.sorted.clear();
        for (TermSource ts : this.sources) {
            if (!ts.hasTop()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"jump called, but ts.topKey is null, this one needs to move to next row.");
                }
                Key startKey = new Key(jumpKey.getRow(), ts.dataLocation, new Text(ts.term + "\u0000" + jumpKey.getColumnFamily()));
                Key endKey = null;
                if (this.parentEndRow != null) {
                    endKey = new Key(this.parentEndRow);
                }
                Range newRange = new Range(startKey, true, endKey, false);
                ts.iter.seek(newRange, this.columnFamilies, this.inclusive);
                ts.setNew();
                this.advanceToMatch(ts);
                ts.setNew();
            } else {
                int comp = this.topKey.getRow().compareTo((BinaryComparable)jumpKey.getRow());
                if (comp > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"jump, our row is ahead of jumpKey.");
                        log.debug((Object)("jumpRow: " + jumpKey.getRow() + " myRow: " + this.topKey.getRow() + " parentEndRow" + this.parentEndRow));
                    }
                    if (ts.hasTop()) {
                        this.sorted.add(ts);
                    }
                } else if (comp < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"OR jump, row jump");
                    }
                    Key endKey = null;
                    if (this.parentEndRow != null) {
                        endKey = new Key(this.parentEndRow);
                    }
                    Key sKey = new Key(jumpKey.getRow());
                    Range fake = new Range(sKey, true, endKey, false);
                    ts.iter.seek(fake, this.columnFamilies, this.inclusive);
                    ts.setNew();
                    this.advanceToMatch(ts);
                    ts.setNew();
                } else {
                    int ucomp;
                    String myUid = OrIterator.getUID(ts.topKey);
                    String jumpUid = OrIterator.getUID(jumpKey);
                    if (log.isDebugEnabled()) {
                        if (myUid == null) {
                            log.debug((Object)"myUid is null");
                        } else {
                            log.debug((Object)("myUid: " + myUid));
                        }
                        if (jumpUid == null) {
                            log.debug((Object)"jumpUid is null");
                        } else {
                            log.debug((Object)("jumpUid: " + jumpUid));
                        }
                    }
                    if ((ucomp = myUid.compareTo(jumpUid)) < 0) {
                        Text row = ts.topKey.getRow();
                        Text cf = ts.topKey.getColumnFamily();
                        String cq = ts.topKey.getColumnQualifier().toString().replaceAll(myUid, jumpUid);
                        Text cq_text = new Text(cq);
                        Key sKey = new Key(row, cf, cq_text);
                        Key eKey = null;
                        if (this.parentEndRow != null) {
                            eKey = new Key(this.parentEndRow);
                        }
                        Range fake = new Range(sKey, true, eKey, false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("uid jump, new ts.iter.seek range: " + fake));
                        }
                        ts.iter.seek(fake, this.columnFamilies, this.inclusive);
                        ts.setNew();
                        this.advanceToMatch(ts);
                        ts.setNew();
                        if (log.isDebugEnabled()) {
                            if (ts.iter.hasTop()) {
                                log.debug((Object)("ts.iter.topkey: " + ts.iter.getTopKey()));
                            } else {
                                log.debug((Object)"ts.iter.topKey is null");
                            }
                        }
                    }
                }
            }
            if (!ts.hasTop()) continue;
            if (this.overallRange != null) {
                if (!this.overallRange.contains(this.topKey)) continue;
                this.sorted.add(ts);
                continue;
            }
            this.sorted.add(ts);
        }
        this.currentTerm = this.sorted.poll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.jump currentTerm = " + this.currentTerm));
        }
        this.topKey = this.buildTopKey(this.currentTerm);
        if (log.isDebugEnabled()) {
            log.debug((Object)("OI.jump new topKey >>" + (this.topKey == null ? "false" : this.topKey) + "<< "));
        }
        return this.hasTop();
    }

    private void printTopKeysForTermSources() {
        if (log.isDebugEnabled()) {
            for (TermSource ts : this.sources) {
                if (ts != null) {
                    if (ts.topKey == null) {
                        log.debug((Object)(ts.toString() + " topKey is null"));
                        continue;
                    }
                    log.debug((Object)(ts.toString() + " topKey: " + ts.topKey));
                    continue;
                }
                log.debug((Object)"ts is null");
            }
            if (this.topKey != null) {
                log.debug((Object)("OrIterator current topKey: " + this.topKey));
            } else {
                log.debug((Object)"OrIterator current topKey is null");
            }
        }
    }

    protected static class TermSource
    implements Comparable<TermSource> {
        public SortedKeyValueIterator<Key, Value> iter;
        public Text dataLocation;
        public Text term;
        public Text docid;
        public Text fieldTerm;
        public Key topKey;
        public boolean atEnd;

        public TermSource(TermSource other) {
            this.iter = other.iter;
            this.term = other.term;
            this.dataLocation = other.dataLocation;
            this.atEnd = other.atEnd;
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text term) {
            this.iter = iter;
            this.term = term;
            this.atEnd = false;
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text dataLocation, Text term) {
            this.iter = iter;
            this.dataLocation = dataLocation;
            this.term = term;
            this.atEnd = false;
        }

        public void setNew() {
            if (!this.atEnd && this.iter.hasTop()) {
                this.topKey = (Key)this.iter.getTopKey();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OI.TermSource.setNew TS.iter.topKey >>" + this.topKey + "<<"));
                }
                if (this.term == null) {
                    this.docid = this.topKey.getColumnQualifier();
                } else {
                    String cqString = this.topKey.getColumnQualifier().toString();
                    int idx = cqString.indexOf("\u0000");
                    this.fieldTerm = new Text(cqString.substring(0, idx));
                    this.docid = new Text(cqString.substring(idx + 1));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OI.TermSource.setNew Setting to null...");
                }
                this.topKey = null;
                this.fieldTerm = null;
                this.docid = null;
            }
        }

        @Override
        public int compareTo(TermSource o) {
            Key k1 = this.topKey;
            Key k2 = o.topKey;
            String uid1 = OrIterator.getUID(k1);
            String uid2 = OrIterator.getUID(k2);
            if (uid1 != null && uid2 != null) {
                return uid1.compareTo(uid2);
            }
            if (uid1 == null && uid2 == null) {
                return 0;
            }
            if (uid1 == null) {
                return 1;
            }
            return -1;
        }

        public String toString() {
            return "TermSource: " + this.dataLocation + " " + this.term;
        }

        public boolean hasTop() {
            return this.topKey != null;
        }
    }
}

