/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.support.FieldIndexKeyParser;

public class UniqFieldNameValueIterator
extends WrappingIterator {
    protected static final Logger log = Logger.getLogger(UniqFieldNameValueIterator.class);
    private static final Collection<ByteSequence> EMPTY_COL_FAMS = new ArrayList<ByteSequence>();
    private SortedKeyValueIterator<Key, Value> source;
    private FieldIndexKeyParser keyParser;
    private Key topKey = null;
    private Value topValue = null;
    private Range overallRange = null;
    private Range currentSubRange;
    private Text fieldName = null;
    private Text fieldValueLowerBound = null;
    private Text fieldValueUpperBound = null;
    private boolean multiRow = false;
    private boolean seekInclusive = false;

    public UniqFieldNameValueIterator(Text fName, Text fValLower, Text fValUpper) {
        this.fieldName = fName;
        this.fieldValueLowerBound = fValLower;
        this.fieldValueUpperBound = fValUpper;
        this.keyParser = this.createDefaultKeyParser();
    }

    public UniqFieldNameValueIterator(UniqFieldNameValueIterator other, IteratorEnvironment env) {
        this.source = other.getSource().deepCopy(env);
        this.keyParser = this.createDefaultKeyParser();
    }

    public static void setLogLevel(Level l) {
        log.setLevel(l);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        source = super.getSource();
    }

    protected SortedKeyValueIterator<Key, Value> getSource() {
        return this.source;
    }

    protected void setSource(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new UniqFieldNameValueIterator(this, env);
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"next()");
        }
        if (!this.source.hasTop()) {
            this.topKey = null;
            this.topValue = null;
            return;
        }
        Key currentKey = this.topKey;
        this.keyParser.parse(this.topKey);
        String fValue = this.keyParser.getFieldValue();
        Text currentRow = currentKey.getRow();
        Text currentFam = currentKey.getColumnFamily();
        if (this.overallRange.getEndKey() != null && this.overallRange.getEndKey().getRow().compareTo((BinaryComparable)currentRow) < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("next, overall endRow: " + this.overallRange.getEndKey().getRow() + "  currentRow: " + currentRow));
            }
            this.topKey = null;
            this.topValue = null;
            return;
        }
        if (fValue.compareTo(this.fieldValueUpperBound.toString()) > 0) {
            this.topKey = null;
            this.topValue = null;
            return;
        }
        Key followingKey = new Key(currentKey.getRow(), this.fieldName, new Text(fValue + "\u0001"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("next, followingKey to seek on: " + followingKey));
        }
        Range r = new Range(followingKey, followingKey);
        this.source.seek(r, EMPTY_COL_FAMS, false);
        while (true) {
            if (!this.source.hasTop()) {
                this.topKey = null;
                this.topValue = null;
                return;
            }
            Key k = (Key)this.source.getTopKey();
            if (!this.overallRange.contains(k)) {
                this.topKey = null;
                this.topValue = null;
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("next(), key: " + k + " subrange: " + this.currentSubRange));
            }
            this.keyParser.parse(k);
            Text currentVal = new Text(this.keyParser.getFieldValue());
            if (k.getRow().equals((Object)currentRow) && k.getColumnFamily().equals((Object)currentFam) && currentVal.compareTo((BinaryComparable)this.fieldValueUpperBound) <= 0) {
                this.topKey = k;
                this.topValue = (Value)this.source.getTopValue();
                return;
            }
            if (!this.overallRange.contains(k) || !this.multiRow) break;
            if (k.getRow().equals((Object)currentRow)) {
                currentRow = this.getNextRow();
                if (currentRow == null) {
                    this.topKey = null;
                    this.topValue = null;
                    return;
                }
            } else {
                currentRow = ((Key)this.source.getTopKey()).getRow();
            }
            Key sKey = new Key(currentRow, this.fieldName, this.fieldValueLowerBound);
            Key eKey = new Key(currentRow, this.fieldName, this.fieldValueUpperBound);
            this.currentSubRange = new Range(sKey, eKey);
            this.source.seek(this.currentSubRange, EMPTY_COL_FAMS, this.seekInclusive);
        }
        this.topKey = null;
        this.topValue = null;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Key eKey;
        Key sKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, range: " + range));
        }
        this.overallRange = range;
        this.seekInclusive = inclusive;
        this.source.seek(range, EMPTY_COL_FAMS, inclusive);
        this.topKey = null;
        this.topValue = null;
        if (range.isInfiniteStartKey()) {
            sKey = (Key)this.source.getTopKey();
            if (sKey == null) {
                return;
            }
        } else {
            sKey = range.getStartKey();
        }
        if (range.isInfiniteStopKey()) {
            eKey = null;
            this.multiRow = true;
        } else {
            eKey = range.getEndKey();
            this.multiRow = !sKey.getRow().equals((Object)eKey.getRow());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, multiRow:" + this.multiRow + " range:" + range));
        }
        Text sRow = sKey.getRow();
        Key ssKey = new Key(sRow, this.fieldName, this.fieldValueLowerBound);
        Key eeKey = new Key(sRow, this.fieldName, this.fieldValueUpperBound);
        this.currentSubRange = new Range(ssKey, eeKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, currentSubRange: " + this.currentSubRange));
        }
        this.source.seek(this.currentSubRange, columnFamilies, inclusive);
        while (this.topKey == null) {
            if (this.source.hasTop()) {
                Key k = (Key)this.source.getTopKey();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("seek, source.topKey: " + k));
                }
                if (this.currentSubRange.contains(k)) {
                    this.topKey = k;
                    this.topValue = (Value)this.source.getTopValue();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"seek, source has top in valid range");
                    continue;
                }
                if (this.multiRow && this.overallRange.contains(k)) {
                    Key fKey = sKey.followingKey(PartialKey.ROW);
                    Range fRange = new Range(fKey, eKey);
                    this.source.seek(fRange, columnFamilies, inclusive);
                    if (this.source.hasTop()) {
                        Text row = ((Key)this.source.getTopKey()).getRow();
                        Key nKey = new Key(row, this.fieldName, this.fieldValueLowerBound);
                        this.currentSubRange = new Range(nKey, eKey);
                        sKey = this.currentSubRange.getStartKey();
                        Range nextRange = new Range(sKey, eKey);
                        this.source.seek(nextRange, columnFamilies, inclusive);
                        continue;
                    }
                    this.topKey = null;
                    this.topValue = null;
                    return;
                }
                this.topKey = null;
                this.topValue = null;
                return;
            }
            this.topKey = null;
            this.topValue = null;
            return;
        }
    }

    private FieldIndexKeyParser createDefaultKeyParser() {
        FieldIndexKeyParser parser = new FieldIndexKeyParser();
        return parser;
    }

    private Text getNextRow() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNextRow()");
        }
        Key fakeKey = new Key(((Key)this.source.getTopKey()).followingKey(PartialKey.ROW));
        Range fakeRange = new Range(fakeKey, fakeKey);
        this.source.seek(fakeRange, EMPTY_COL_FAMS, false);
        if (this.source.hasTop()) {
            return ((Key)this.source.getTopKey()).getRow();
        }
        return null;
    }
}

