/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.lang.math.NumberUtils;

public class Arithmetic
extends JexlArithmetic {
    public Arithmetic(boolean lenient) {
        super(lenient);
    }

    public boolean matches(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        String arg = left.toString();
        if (right instanceof Pattern) {
            return ((Pattern)right).matcher(arg).matches();
        }
        Pattern p = Pattern.compile(right.toString(), 32);
        Matcher m = p.matcher(arg);
        return m.matches();
    }

    public boolean equals(Object left, Object right) {
        Object fixedLeft = this.fixLeft(left, right);
        return super.equals(fixedLeft, right);
    }

    public boolean lessThan(Object left, Object right) {
        Object fixedLeft = this.fixLeft(left, right);
        return super.lessThan(fixedLeft, right);
    }

    protected Object fixLeft(Object left, Object right) {
        if (null == left || null == right) {
            return left;
        }
        if (!(right instanceof Number) && left instanceof Number) {
            right = NumberUtils.createNumber((String)right.toString());
        }
        if (right instanceof Number && left instanceof Number) {
            if (right instanceof Double) {
                return (double)((Double)right);
            }
            if (right instanceof Float) {
                return Float.valueOf(((Float)right).floatValue());
            }
            if (right instanceof Long) {
                return (long)((Long)right);
            }
            if (right instanceof Integer) {
                return (int)((Integer)right);
            }
            if (right instanceof Short) {
                return (short)((Short)right);
            }
            if (right instanceof Byte) {
                return (byte)((Byte)right);
            }
            return right;
        }
        if (right instanceof Number && left instanceof String) {
            Number num = NumberUtils.createNumber((String)left.toString());
            if (this.isFloatingPointNumber(right) && this.isFloatingPointNumber(left)) {
                return num;
            }
            if (this.isFloatingPointNumber(right)) {
                return num.doubleValue();
            }
            if (right instanceof Number) {
                return num.longValue();
            }
        } else if (right instanceof Boolean && left instanceof String) {
            if (left.equals("true") || left.equals("false")) {
                return Boolean.parseBoolean(left.toString());
            }
            Number num = NumberUtils.createNumber((String)left.toString());
            if (num.intValue() == 1) {
                return true;
            }
            if (num.intValue() == 0) {
                return false;
            }
        }
        return left;
    }
}

