/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.Key;

public class BaseKeyParser {
    public static final String ROW_FIELD = "row";
    public static final String COLUMN_FAMILY_FIELD = "columnFamily";
    public static final String COLUMN_QUALIFIER_FIELD = "columnQualifier";
    protected Map<String, String> keyFields = new HashMap<String, String>();
    protected Key key = null;

    public void parse(Key key) {
        this.key = key;
        this.keyFields.clear();
        this.keyFields.put(ROW_FIELD, key.getRow().toString());
        this.keyFields.put(COLUMN_FAMILY_FIELD, key.getColumnFamily().toString());
        this.keyFields.put(COLUMN_QUALIFIER_FIELD, key.getColumnQualifier().toString());
    }

    public String getFieldValue(String fieldName) {
        return this.keyFields.get(fieldName);
    }

    public String[] getFieldNames() {
        String[] fieldNames = new String[this.keyFields.size()];
        return this.keyFields.keySet().toArray(fieldNames);
    }

    public BaseKeyParser duplicate() {
        return new BaseKeyParser();
    }

    public String getRow() {
        return this.keyFields.get(ROW_FIELD);
    }

    public String getColumnFamily() {
        return this.keyFields.get(COLUMN_FAMILY_FIELD);
    }

    public String getColumnQualifier() {
        return this.keyFields.get(COLUMN_QUALIFIER_FIELD);
    }

    public Key getKey() {
        return this.key;
    }
}

