/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.AndIterator;
import org.calrissian.accumulorecipes.commons.iterators.FieldIndexIterator;
import org.calrissian.accumulorecipes.commons.iterators.OrIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.JexlOperatorConstants;

public class BooleanLogicTreeNode
extends DefaultMutableTreeNode {
    protected static final Logger log = Logger.getLogger(BooleanLogicTreeNode.class);
    private static final long serialVersionUID = 1L;
    private Key myTopKey = null;
    private Key advanceKey = null;
    private Text fValue = null;
    private Text fName = null;
    private boolean negated = false;
    private int type;
    private boolean done = false;
    private boolean valid = false;
    private boolean rollUp = false;
    private String fOperator = null;
    private boolean childrenAllNegated = false;
    private HashSet<Key> uids;
    private Text upperBound;
    private Text lowerBound;
    private boolean rangeNode;

    public BooleanLogicTreeNode() {
        this.uids = new HashSet();
    }

    public BooleanLogicTreeNode(int type) {
        this.type = type;
        this.uids = new HashSet();
        this.setOperator();
    }

    public BooleanLogicTreeNode(int type, boolean negate) {
        this.type = type;
        this.negated = negate;
        this.uids = new HashSet();
        this.setOperator();
    }

    public BooleanLogicTreeNode(int type, String fieldName, String fieldValue) {
        this.type = type;
        if (fieldValue != null) {
            this.fValue = new Text(fieldValue);
        }
        if (fieldName != null) {
            this.fName = new Text(fieldName);
        }
        this.uids = new HashSet();
        this.setOperator();
    }

    public BooleanLogicTreeNode(int type, String fieldName, String fieldValue, boolean negated) {
        this.type = type;
        if (fieldValue != null) {
            this.fValue = new Text(fieldValue);
        }
        if (fieldName != null) {
            this.fName = new Text(fieldName);
        }
        this.uids = new HashSet();
        this.negated = negated;
        this.setOperator();
    }

    public static Key buildKey(Key key) {
        if (key == null) {
            log.error((Object)"Problem in BooleanLogicTreeNodeJexl.buildKey");
            return null;
        }
        String[] cq = key.getColumnQualifier().toString().split("\u0000");
        Text uuid = new Text(cq.length > 1 ? cq[1] : cq[0]);
        Text row = key.getRow();
        log.debug((Object)("Key-> r:" + row + "  fam:" + uuid));
        Key k = new Key(row, uuid);
        return k;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public boolean isChildrenAllNegated() {
        return this.childrenAllNegated;
    }

    public void setChildrenAllNegated(boolean childrenAllNegated) {
        this.childrenAllNegated = childrenAllNegated;
    }

    public Key getAdvanceKey() {
        return this.advanceKey;
    }

    public void setAdvanceKey(Key advanceKey) {
        this.advanceKey = advanceKey;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean b) {
        this.negated = b;
    }

    public Key getTopKey() {
        return this.myTopKey;
    }

    public void setTopKey(Key id) {
        this.myTopKey = id;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isRollUp() {
        return this.rollUp;
    }

    public void setRollUp(boolean rollUp) {
        this.rollUp = rollUp;
    }

    public Text getFieldValue() {
        return this.fValue;
    }

    public void setFieldValue(Text term) {
        this.fValue = term;
    }

    public Text getFieldName() {
        return this.fName;
    }

    public void setFieldName(Text dataLocation) {
        this.fName = dataLocation;
    }

    public String getFieldOperator() {
        return this.fOperator;
    }

    private void setOperator() {
        this.fOperator = JexlOperatorConstants.getOperator(this.type);
        if (this.negated && this.fOperator.equals("!=")) {
            this.fOperator = JexlOperatorConstants.getOperator(14);
        }
    }

    public Text getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Text lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Text getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Text upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isRangeNode() {
        return this.rangeNode;
    }

    public void setRangeNode(boolean rangeNode) {
        this.rangeNode = rangeNode;
    }

    public String getContents() {
        StringBuilder s = new StringBuilder("[");
        s.append(this.toString());
        if (this.children != null) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                BooleanLogicTreeNode n = (BooleanLogicTreeNode)e.nextElement();
                s.append(",");
                s.append(n.getContents());
            }
        }
        s.append("]");
        return s.toString();
    }

    public String printNode() {
        StringBuilder s = new StringBuilder("[");
        s.append("Full Location & Term = ");
        if (this.fName != null) {
            s.append(this.fName.toString());
        } else {
            s.append("BlankDataLocation");
        }
        s.append("  ");
        if (this.fValue != null) {
            s.append(this.fValue.toString());
        } else {
            s.append("BlankTerm");
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public String toString() {
        String uidStr = "none";
        if (this.myTopKey != null) {
            String cf;
            uidStr = cf = this.myTopKey.getColumnFamily().toString();
        }
        switch (this.type) {
            case 14: {
                return this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 15: {
                return this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 20: {
                return this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 21: {
                return this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 18: {
                return "<=:" + this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 16: {
                return "<:" + this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 19: {
                return ">=:" + this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 17: {
                return ">:" + this.fName.toString() + ":" + this.fValue.toString() + ", uid=" + uidStr + " , negation=" + this.isNegated();
            }
            case 0: {
                return "HEAD:" + uidStr + ":" + this.isValid();
            }
            case 10: {
                return "AND:" + uidStr + ":" + this.isValid();
            }
            case 29: {
                return "NOT";
            }
            case 9: {
                return "OR:" + uidStr + ":" + this.isValid();
            }
        }
        System.out.println("Problem in BLTNODE.toString()");
        return null;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.setTopKey(null);
        this.setDone(false);
        SortedKeyValueIterator iter = (SortedKeyValueIterator)this.getUserObject();
        if (iter != null) {
            iter.seek(range, columnFamilies, inclusive);
            if (iter.hasTop()) {
                Key key = (Key)iter.getTopKey();
                key = BooleanLogicTreeNode.buildKey(key);
                this.setTopKey(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BLTNODE.seek() -> found: " + this.getTopKey()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BLTNODE.seek() -> hasTop::false");
                }
                this.setDone(true);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BLTNODE.seek(), The iterator was null!");
            }
            this.setTopKey(null);
        }
    }

    public String buildTreePathString(TreeNode[] path) {
        StringBuilder s = new StringBuilder("[");
        for (TreeNode p : path) {
            s.append(p.toString());
            s.append(",");
        }
        s.deleteCharAt(s.length() - 1);
        s.append("]");
        return s.toString();
    }

    public void next() throws IOException {
        this.setTopKey(null);
        if (log.isDebugEnabled()) {
            TreeNode[] path = this.getPath();
            log.debug((Object)("BLTNODE.next() path-> " + this.buildTreePathString(path)));
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"I've been marked as done, returning");
            }
            return;
        }
        SortedKeyValueIterator iter = (SortedKeyValueIterator)this.getUserObject();
        iter.next();
        if (iter.hasTop()) {
            Key key = (Key)iter.getTopKey();
            key = BooleanLogicTreeNode.buildKey(key);
            this.setTopKey(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("BLTNODE.next() -> found: " + this.getTopKey()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BLTNODE.next() -> Nothing found");
            }
            this.setTopKey(null);
            this.setDone(true);
        }
    }

    public boolean jump(Key jumpKey) throws IOException {
        boolean ok = true;
        if (this.getType() == 14) {
            FieldIndexIterator iter = (FieldIndexIterator)((Object)this.getUserObject());
            ok = iter.jump(jumpKey);
            if (iter.hasTop()) {
                Key key = iter.getTopKey();
                key = BooleanLogicTreeNode.buildKey(key);
                this.setTopKey(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BLTNODE.jump() -> found: " + this.getTopKey()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"FieldIndexIteratorJexl does not have top after jump, marking done.");
                }
                this.setTopKey(null);
                this.setDone(true);
            }
        } else if (this.getType() == 10) {
            AndIterator iter = (AndIterator)this.getUserObject();
            ok = iter.jump(jumpKey);
            if (iter.hasTop()) {
                Key key = iter.getTopKey();
                key = BooleanLogicTreeNode.buildKey(key);
                this.setTopKey(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BLTNODE.jump() -> found: " + this.getTopKey()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"IntersectingIteratorJexl does not have top after jump, marking done.");
                }
                this.setTopKey(null);
                this.setDone(true);
            }
        } else if (this.getType() == 9) {
            OrIterator iter = (OrIterator)this.getUserObject();
            ok = iter.jump(jumpKey);
            if (iter.hasTop()) {
                Key key = iter.getTopKey();
                key = BooleanLogicTreeNode.buildKey(key);
                this.setTopKey(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BLTNODE.jump() -> found: " + this.getTopKey()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OrIteratorJexl does not have top after jump, marking done.");
                }
                this.setTopKey(null);
                this.setDone(true);
            }
        }
        return ok;
    }

    public void addToSet(Key i) {
        this.uids.add(i);
    }

    public void reSet() {
        this.uids = new HashSet();
    }

    public boolean inSet(Key t) {
        return this.uids.contains(t);
    }

    public Iterator<Key> getSetIterator() {
        return this.uids.iterator();
    }

    public HashSet<Key> getIntersection(HashSet<Key> h) {
        h.retainAll(this.uids);
        return h;
    }

    public Key getMinUniqueID() {
        Iterator<Key> iter = this.uids.iterator();
        Key min = null;
        while (iter.hasNext()) {
            Key t = iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OR set member: " + t));
            }
            if (t == null) continue;
            if (min == null) {
                min = t;
                continue;
            }
            if (t.compareTo(min) >= 0) continue;
            min = t;
        }
        return min;
    }

    public boolean hasTop() {
        if (this.getType() == 9) {
            if (!this.isLeaf()) {
                return this.uids.size() > 0;
            }
            return this.getTopKey() != null;
        }
        return this.getTopKey() != null;
    }
}

