/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import com.esotericsoftware.kryo.CustomSerialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.ArraySerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.security.ColumnVisibility;

public class EventFields
implements SetMultimap<String, FieldValue>,
CustomSerialization {
    private static boolean kryoInitialized = false;
    private static ArraySerializer valueSerializer = null;
    private Multimap<String, FieldValue> map = HashMultimap.create();

    public static synchronized void initializeKryo(Kryo kryo) {
        if (kryoInitialized) {
            return;
        }
        valueSerializer = new ArraySerializer(kryo);
        valueSerializer.setDimensionCount(Integer.valueOf(1));
        valueSerializer.setElementsAreSameType(true);
        valueSerializer.setCanBeNull(false);
        valueSerializer.setElementsCanBeNull(false);
        kryo.register(byte[].class, (Serializer)valueSerializer);
        kryoInitialized = true;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(String key, FieldValue value) {
        return this.map.put((Object)key, (Object)value);
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(String key, Iterable<? extends FieldValue> values) {
        return this.map.putAll((Object)key, values);
    }

    public boolean putAll(Multimap<? extends String, ? extends FieldValue> multimap) {
        return this.map.putAll(multimap);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Multiset<String> keys() {
        return this.map.keys();
    }

    public Collection<FieldValue> values() {
        return this.map.values();
    }

    public Set<FieldValue> get(String key) {
        return (Set)this.map.get((Object)key);
    }

    public Set<FieldValue> removeAll(Object key) {
        return (Set)this.map.removeAll(key);
    }

    public Set<FieldValue> replaceValues(String key, Iterable<? extends FieldValue> values) {
        return (Set)this.map.replaceValues((Object)key, values);
    }

    public Set<Map.Entry<String, FieldValue>> entries() {
        return (Set)this.map.entries();
    }

    public Map<String, Collection<FieldValue>> asMap() {
        return this.map.asMap();
    }

    public int getByteSize() {
        int count = 0;
        for (Map.Entry e : this.map.entries()) {
            count += ((String)e.getKey()).getBytes().length + ((FieldValue)e.getValue()).size();
        }
        return count;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : this.map.entries()) {
            buf.append("\tkey: ").append((String)entry.getKey()).append(" -> ").append(((FieldValue)entry.getValue()).toString()).append("\n");
        }
        return buf.toString();
    }

    public void readObjectData(Kryo kryo, ByteBuffer buf) {
        if (!kryoInitialized) {
            EventFields.initializeKryo(kryo);
        }
        int entries = IntSerializer.get((ByteBuffer)buf, (boolean)true);
        for (int i = 0; i < entries; ++i) {
            String key = StringSerializer.get((ByteBuffer)buf);
            ColumnVisibility vis = new ColumnVisibility((byte[])valueSerializer.readObjectData(buf, byte[].class));
            byte[] value = (byte[])valueSerializer.readObjectData(buf, byte[].class);
            byte[] metadata = (byte[])valueSerializer.readObjectData(buf, byte[].class);
            this.map.put((Object)key, (Object)new FieldValue(vis, value, metadata));
        }
    }

    public void writeObjectData(Kryo kryo, ByteBuffer buf) {
        if (!kryoInitialized) {
            EventFields.initializeKryo(kryo);
        }
        IntSerializer.put((ByteBuffer)buf, (int)this.map.size(), (boolean)true);
        for (Map.Entry entry : this.map.entries()) {
            StringSerializer.put((ByteBuffer)buf, (String)((String)entry.getKey()));
            valueSerializer.writeObjectData(buf, (Object)(((FieldValue)entry.getValue()).getVisibility().getExpression().length > 0 ? ((FieldValue)entry.getValue()).getVisibility().flatten() : ((FieldValue)entry.getValue()).getVisibility().getExpression()));
            valueSerializer.writeObjectData(buf, (Object)((FieldValue)entry.getValue()).getValue());
            valueSerializer.writeObjectData(buf, (Object)((FieldValue)entry.getValue()).getMetadata());
        }
    }

    public static class FieldValue {
        ColumnVisibility visibility;
        byte[] value;
        byte[] metadata;

        public FieldValue(ColumnVisibility visibility, byte[] value, byte[] metadata) {
            this.visibility = visibility;
            this.value = value;
            this.metadata = metadata;
        }

        public ColumnVisibility getVisibility() {
            return this.visibility;
        }

        public void setVisibility(ColumnVisibility visibility) {
            this.visibility = visibility;
        }

        public byte[] getValue() {
            return this.value;
        }

        public byte[] getMetadata() {
            return this.metadata;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public int size() {
            return this.visibility.getExpression().length > 0 ? this.visibility.flatten().length + this.value.length + this.metadata.length : this.value.length + this.metadata.length;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (null != this.visibility) {
                buf.append(" visibility: ").append(new String(this.visibility.flatten()));
            }
            if (null != this.value) {
                buf.append(" value size: ").append(this.value.length);
            }
            if (null != this.value) {
                buf.append(" value: ").append(new String(this.value));
            }
            if (null != this.metadata) {
                buf.append(" value size: ").append(this.metadata.length);
            }
            if (null != this.metadata) {
                buf.append(" value: ").append(new String(this.metadata));
            }
            return buf.toString();
        }
    }
}

