/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import org.apache.accumulo.core.data.Key;
import org.calrissian.accumulorecipes.commons.iterators.support.BaseKeyParser;

public class KeyParser
extends BaseKeyParser {
    public static final String SELECTOR_FIELD = "selector";
    public static final String DATATYPE_FIELD = "dataType";
    public static final String FIELDNAME_FIELD = "fieldName";
    public static final String UID_FIELD = "uid";

    @Override
    public void parse(Key key) {
        super.parse(key);
        String[] colFamParts = ((String)this.keyFields.get("columnFamily")).split("\u0000");
        this.keyFields.put(FIELDNAME_FIELD, colFamParts.length >= 2 ? colFamParts[1] : "");
        String[] colQualParts = ((String)this.keyFields.get("columnQualifier")).split("\u0000");
        this.keyFields.put(SELECTOR_FIELD, colQualParts.length >= 1 ? colQualParts[0] : "");
        this.keyFields.put(DATATYPE_FIELD, colQualParts.length >= 2 ? colQualParts[1] : "");
        this.keyFields.put(UID_FIELD, colQualParts.length >= 3 ? colQualParts[2] : "");
    }

    @Override
    public BaseKeyParser duplicate() {
        return new KeyParser();
    }

    public String getSelector() {
        return (String)this.keyFields.get(SELECTOR_FIELD);
    }

    public String getDataType() {
        return (String)this.keyFields.get(DATATYPE_FIELD);
    }

    public String getFieldName() {
        return (String)this.keyFields.get(FIELDNAME_FIELD);
    }

    public String getUid() {
        return (String)this.keyFields.get(UID_FIELD);
    }

    public String getDataTypeUid() {
        return this.getDataType() + "\u0000" + this.getUid();
    }

    public String getFieldValue() {
        return this.getSelector();
    }
}

