/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import java.util.Collection;
import java.util.Iterator;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanLeaf;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.InLeaf;
import org.calrissian.mango.criteria.domain.LessThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.LessThanLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.NotInLeaf;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;
import org.calrissian.mango.types.TypeRegistry;

public class NodeToJexl {
    TypeRegistry<String> registry;

    public NodeToJexl(TypeRegistry<String> registry) {
        this.registry = registry;
    }

    public String transform(Node node) {
        try {
            if (node instanceof ParentNode) {
                return this.processParent(node);
            }
            return this.processChild(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String processParent(Node node) throws Exception {
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < node.children().size(); ++i) {
            Node child = (Node)node.children().get(i);
            String newJexl = child instanceof ParentNode ? this.processParent(child) : this.processChild(child);
            builder.append(newJexl);
            if (i >= node.children().size() - 1) continue;
            if (node instanceof AndNode) {
                builder.append(" and ");
                continue;
            }
            if (!(node instanceof OrNode)) continue;
            builder.append(" or ");
        }
        return builder.append(")").toString();
    }

    private String processChild(Node node) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (node instanceof EqualsLeaf) {
            builder.append("(");
            EqualsLeaf leaf = (EqualsLeaf)node;
            return builder.append(leaf.getKey()).append(" == '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof NotEqualsLeaf) {
            builder.append("(");
            NotEqualsLeaf leaf = (NotEqualsLeaf)node;
            return builder.append(leaf.getKey()).append(" != '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof RangeLeaf) {
            builder.append("(");
            RangeLeaf leaf = (RangeLeaf)node;
            return builder.append(leaf.getKey()).append(" >= '").append(this.registry.getAlias(leaf.getStart())).append("\u0001").append((String)this.registry.encode(leaf.getStart())).append("')").append(" and (").append(leaf.getKey()).append(" <= '").append(this.registry.getAlias(leaf.getEnd())).append("\u0001").append((String)this.registry.encode(leaf.getEnd())).append("')").toString();
        }
        if (node instanceof GreaterThanLeaf) {
            builder.append("(");
            GreaterThanLeaf leaf = (GreaterThanLeaf)node;
            return builder.append(leaf.getKey()).append(" > '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof GreaterThanEqualsLeaf) {
            builder.append("(");
            GreaterThanEqualsLeaf leaf = (GreaterThanEqualsLeaf)node;
            return builder.append(leaf.getKey()).append(" >= '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof LessThanLeaf) {
            builder.append("(");
            LessThanLeaf leaf = (LessThanLeaf)node;
            return builder.append(leaf.getKey()).append(" < '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof LessThanEqualsLeaf) {
            builder.append("(");
            LessThanEqualsLeaf leaf = (LessThanEqualsLeaf)node;
            return builder.append(leaf.getKey()).append(" <= '").append(this.registry.getAlias(leaf.getValue())).append("\u0001").append((String)this.registry.encode(leaf.getValue())).append("')").toString();
        }
        if (node instanceof HasLeaf) {
            builder.append("(");
            HasLeaf leaf = (HasLeaf)node;
            return builder.append(leaf.getKey()).append(" >= '").append("\u0000").append("')").toString();
        }
        if (node instanceof HasNotLeaf) {
            builder.append("!(");
            HasNotLeaf leaf = (HasNotLeaf)node;
            return builder.append(leaf.getKey()).append(" >= '").append("\u0000").append("')").toString();
        }
        if (node instanceof InLeaf) {
            builder.append("(");
            InLeaf leaf = (InLeaf)node;
            Collection objs = (Collection)leaf.getValue();
            Iterator objectIterator = objs.iterator();
            while (objectIterator.hasNext()) {
                Object val = objectIterator.next();
                builder.append(leaf.getKey()).append(" == '").append(this.registry.getAlias(val)).append("\u0001").append((String)this.registry.encode(val)).toString();
                if (!objectIterator.hasNext()) continue;
                builder.append("' or ");
            }
            return builder.append("')").toString();
        }
        if (node instanceof NotInLeaf) {
            builder.append("(");
            NotInLeaf leaf = (NotInLeaf)node;
            Collection objs = (Collection)leaf.getValue();
            Iterator objectIterator = objs.iterator();
            while (objectIterator.hasNext()) {
                Object val = objectIterator.next();
                builder.append(leaf.getKey()).append(" != '").append(this.registry.getAlias(val)).append("\u0001").append((String)this.registry.encode(val)).toString();
                if (!objectIterator.hasNext()) continue;
                builder.append("' and ");
            }
            return builder.append("')").toString();
        }
        throw new RuntimeException("An unsupported leaf type was encountered: " + node.getClass().getName());
    }
}

