/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.support.Arithmetic;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.iterators.support.JexlOperatorConstants;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryFunctions;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryParser;

public class QueryEvaluator {
    private static Logger log = Logger.getLogger(QueryEvaluator.class);
    private static JexlEngine engine = new JexlEngine(null, (JexlArithmetic)new Arithmetic(false), null, null);
    private String query = null;
    private Set<String> literals = null;
    private Multimap<String, QueryParser.QueryTerm> terms = null;
    private String modifiedQuery = null;
    private JexlContext ctx = new MapContext();
    private boolean caseInsensitive = true;

    public QueryEvaluator(String query) throws ParseException {
        this.caseInsensitive = false;
        if (this.caseInsensitive) {
            query = query.toLowerCase();
        }
        this.query = query;
        QueryParser parser = new QueryParser();
        parser.execute(query);
        this.terms = parser.getQueryTerms();
        if (this.caseInsensitive) {
            this.literals = new HashSet<String>();
            for (String lit : parser.getQueryIdentifiers()) {
                this.literals.add(lit.toLowerCase());
            }
        } else {
            this.literals = parser.getQueryIdentifiers();
        }
    }

    public QueryEvaluator(String query, boolean insensitive) throws ParseException {
        this.caseInsensitive = insensitive;
        if (this.caseInsensitive) {
            query = query.toLowerCase();
        }
        this.query = query;
        QueryParser parser = new QueryParser();
        parser.execute(query);
        this.terms = parser.getQueryTerms();
        if (this.caseInsensitive) {
            this.literals = new HashSet<String>();
            for (String lit : parser.getQueryIdentifiers()) {
                this.literals.add(lit.toLowerCase());
            }
        } else {
            this.literals = parser.getQueryIdentifiers();
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void printLiterals() {
        for (String s : this.literals) {
            System.out.println("literal: " + s);
        }
    }

    public void setLevel(Level lev) {
        log.setLevel(lev);
    }

    public StringBuilder rewriteQuery(StringBuilder query, String fieldName, Collection<EventFields.FieldValue> fieldValues) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"rewriteQuery");
        }
        if (this.caseInsensitive) {
            fieldName = fieldName.toLowerCase();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying original criteria: " + query));
        }
        String[] values = new String[fieldValues.size()];
        int idx = 0;
        for (EventFields.FieldValue fv : fieldValues) {
            values[idx] = this.caseInsensitive ? new String(fv.getValue()).toLowerCase() : new String(fv.getValue());
            ++idx;
        }
        this.ctx.set(fieldName, (Object)values);
        Collection qt = this.terms.get((Object)fieldName);
        StringBuilder script = new StringBuilder();
        script.append("_").append(fieldName).append(" = false;\n");
        script.append("for (field : ").append(fieldName).append(") {\n");
        for (QueryParser.QueryTerm t : qt) {
            if (!t.getOperator().equals(JexlOperatorConstants.getOperator(42))) {
                script.append("\tif (_").append(fieldName).append(" == false && field ").append(t.getOperator()).append(" ").append(t.getValue()).append(") { \n");
            } else {
                script.append("\tif (_").append(fieldName).append(" == false && ").append(t.getValue().toString().replace(fieldName, "field")).append(") { \n");
            }
            script.append("\t\t_").append(fieldName).append(" = true;\n");
            script.append("\t}\n");
        }
        script.append("}\n");
        query.insert(0, script.toString());
        StringBuilder newPredicate = new StringBuilder();
        newPredicate.append("_").append(fieldName).append(" == true");
        for (QueryParser.QueryTerm t : qt) {
            StringBuilder predicate = new StringBuilder();
            int start = 0;
            if (!t.getOperator().equals(JexlOperatorConstants.getOperator(42))) {
                predicate.append(fieldName).append(" ").append(t.getOperator()).append(" ").append(t.getValue());
                start = query.indexOf(predicate.toString());
            } else {
                predicate.append(t.getValue().toString());
                start = query.indexOf(predicate.toString());
            }
            if (-1 == start) {
                log.warn((Object)("Unable to find predicate: " + predicate.toString() + " in rewritten criteria: " + query.toString()));
            }
            int length = predicate.length();
            query.replace(start, start + length, newPredicate.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("leaving rewriteQuery with: " + query.toString()));
        }
        return query;
    }

    public boolean evaluate(EventFields eventFields) {
        this.modifiedQuery = null;
        boolean rewritten = false;
        StringBuilder q = new StringBuilder(this.query);
        HashSet<String> literalsCopy = new HashSet<String>(this.literals);
        for (Map.Entry<String, Collection<EventFields.FieldValue>> field : eventFields.asMap().entrySet()) {
            String fName = field.getKey();
            if (this.caseInsensitive) {
                fName = fName.toLowerCase();
            }
            if (!this.literals.contains(fName)) continue;
            literalsCopy.remove(fName);
            if (field.getValue().size() == 0) continue;
            if (field.getValue().size() == 1) {
                if (this.caseInsensitive) {
                    this.ctx.set(field.getKey().toLowerCase(), (Object)new String(field.getValue().iterator().next().getValue()).toLowerCase());
                    continue;
                }
                this.ctx.set(field.getKey(), (Object)new String(field.getValue().iterator().next().getValue()));
                continue;
            }
            q = this.rewriteQuery(q, field.getKey(), field.getValue());
            rewritten = true;
        }
        for (String lit : literalsCopy) {
            this.ctx.set(lit, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Evaluating criteria: " + q.toString()));
        }
        this.modifiedQuery = q.toString();
        Boolean result = null;
        if (rewritten) {
            Script script = engine.createScript(this.modifiedQuery);
            try {
                result = (Boolean)script.execute(this.ctx);
            }
            catch (Exception e) {
                log.error((Object)("Error evaluating script: " + this.modifiedQuery + " against event" + eventFields.toString()), (Throwable)e);
            }
        } else {
            Expression expr = engine.createExpression(this.modifiedQuery);
            try {
                result = (Boolean)expr.evaluate(this.ctx);
            }
            catch (Exception e) {
                log.error((Object)("Error evaluating expression: " + this.modifiedQuery + " against event" + eventFields.toString()), (Throwable)e);
            }
        }
        return null != result && result != false;
    }

    public String getModifiedQuery() {
        return this.modifiedQuery;
    }

    static {
        engine.setSilent(false);
        engine.setCache(128);
        HashMap<String, Class<QueryFunctions>> functions = new HashMap<String, Class<QueryFunctions>>();
        functions.put("f", QueryFunctions.class);
        engine.setFunctions(functions);
    }
}

