/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class QueryFunctions {
    protected static Logger log = Logger.getLogger(QueryFunctions.class);

    public static boolean between(String fieldValue, double left, double right) {
        try {
            Double value = Double.parseDouble(fieldValue);
            return value >= left && value <= right;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean between(String fieldValue, String left, String right) {
        try {
            return fieldValue.compareTo(left) >= 0 && fieldValue.compareTo(right) <= 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean between(String fieldValue, long left, long right) {
        try {
            Long value = Long.parseLong(fieldValue);
            return value >= left && value <= right;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static Number abs(String fieldValue) {
        Number retval = null;
        try {
            Number value = NumberUtils.createNumber((String)fieldValue);
            if (null == value) {
                retval = Integer.MIN_VALUE;
            } else if (value instanceof Long) {
                retval = Math.abs(value.longValue());
            } else if (value instanceof Double) {
                retval = Math.abs(value.doubleValue());
            } else if (value instanceof Float) {
                retval = Float.valueOf(Math.abs(value.floatValue()));
            } else if (value instanceof Integer) {
                retval = Math.abs(value.intValue());
            }
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
        return retval;
    }
}

