/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.jexl2.parser.ASTAdditiveNode;
import org.apache.commons.jexl2.parser.ASTAdditiveOperator;
import org.apache.commons.jexl2.parser.ASTAmbiguous;
import org.apache.commons.jexl2.parser.ASTAndNode;
import org.apache.commons.jexl2.parser.ASTArrayAccess;
import org.apache.commons.jexl2.parser.ASTArrayLiteral;
import org.apache.commons.jexl2.parser.ASTAssignment;
import org.apache.commons.jexl2.parser.ASTBitwiseAndNode;
import org.apache.commons.jexl2.parser.ASTBitwiseComplNode;
import org.apache.commons.jexl2.parser.ASTBitwiseOrNode;
import org.apache.commons.jexl2.parser.ASTBitwiseXorNode;
import org.apache.commons.jexl2.parser.ASTBlock;
import org.apache.commons.jexl2.parser.ASTConstructorNode;
import org.apache.commons.jexl2.parser.ASTDivNode;
import org.apache.commons.jexl2.parser.ASTEQNode;
import org.apache.commons.jexl2.parser.ASTERNode;
import org.apache.commons.jexl2.parser.ASTEmptyFunction;
import org.apache.commons.jexl2.parser.ASTFalseNode;
import org.apache.commons.jexl2.parser.ASTFloatLiteral;
import org.apache.commons.jexl2.parser.ASTForeachStatement;
import org.apache.commons.jexl2.parser.ASTFunctionNode;
import org.apache.commons.jexl2.parser.ASTGENode;
import org.apache.commons.jexl2.parser.ASTGTNode;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTIfStatement;
import org.apache.commons.jexl2.parser.ASTIntegerLiteral;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTLENode;
import org.apache.commons.jexl2.parser.ASTLTNode;
import org.apache.commons.jexl2.parser.ASTMapEntry;
import org.apache.commons.jexl2.parser.ASTMapLiteral;
import org.apache.commons.jexl2.parser.ASTMethodNode;
import org.apache.commons.jexl2.parser.ASTModNode;
import org.apache.commons.jexl2.parser.ASTMulNode;
import org.apache.commons.jexl2.parser.ASTNENode;
import org.apache.commons.jexl2.parser.ASTNRNode;
import org.apache.commons.jexl2.parser.ASTNotNode;
import org.apache.commons.jexl2.parser.ASTNullLiteral;
import org.apache.commons.jexl2.parser.ASTOrNode;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.ASTSizeFunction;
import org.apache.commons.jexl2.parser.ASTSizeMethod;
import org.apache.commons.jexl2.parser.ASTStringLiteral;
import org.apache.commons.jexl2.parser.ASTTernaryNode;
import org.apache.commons.jexl2.parser.ASTTrueNode;
import org.apache.commons.jexl2.parser.ASTUnaryMinusNode;
import org.apache.commons.jexl2.parser.ASTWhileStatement;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.ParserVisitor;
import org.apache.commons.jexl2.parser.SimpleNode;
import org.apache.hadoop.util.hash.Hash;
import org.apache.hadoop.util.hash.MurmurHash;
import org.calrissian.accumulorecipes.commons.iterators.support.JexlOperatorConstants;
import org.calrissian.accumulorecipes.commons.iterators.support.TreeBuilder;
import org.calrissian.accumulorecipes.commons.iterators.support.TreeNode;

public class QueryParser
implements ParserVisitor {
    private static final int SEED = 650567;
    private static LRUMap cache = new LRUMap();
    protected Set<String> negatedTerms = new HashSet<String>();
    private Set<String> andTerms = new HashSet<String>();
    private Set<String> orTerms = new HashSet<String>();
    private Set<Object> literals = new HashSet<Object>();
    private Multimap<String, QueryTerm> terms = HashMultimap.create();
    private ASTJexlScript rootNode = null;
    private TreeNode tree = null;
    private int hashVal = 0;

    private void reset() {
        this.negatedTerms.clear();
        this.andTerms.clear();
        this.orTerms.clear();
        this.literals.clear();
        this.terms = HashMultimap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String query) throws ParseException {
        this.reset();
        query = query.replaceAll("\\s+AND\\s+", " and ");
        query = query.replaceAll("\\s+OR\\s+", " or ");
        query = query.replaceAll("\\s+NOT\\s+", " not ");
        Hash hash = MurmurHash.getInstance();
        this.hashVal = hash.hash(query.getBytes(), 650567);
        CacheEntry entry = null;
        LRUMap lRUMap = cache;
        synchronized (lRUMap) {
            entry = (CacheEntry)cache.get((Object)this.hashVal);
        }
        if (entry != null) {
            this.negatedTerms = entry.getNegatedTerms();
            this.andTerms = entry.getAndTerms();
            this.orTerms = entry.getOrTerms();
            this.literals = entry.getLiterals();
            this.terms = entry.getTerms();
            this.rootNode = entry.getRootNode();
            this.tree = entry.getTree();
        } else {
            Parser p = new Parser((Reader)new StringReader(";"));
            this.rootNode = p.parse((Reader)new StringReader(query), null);
            this.rootNode.childrenAccept((ParserVisitor)this, null);
            TreeBuilder builder = new TreeBuilder(this.rootNode);
            this.tree = builder.getRootNode();
            entry = new CacheEntry(this.negatedTerms, this.andTerms, this.orTerms, this.literals, this.terms, this.rootNode, this.tree);
            LRUMap lRUMap2 = cache;
            synchronized (lRUMap2) {
                cache.put((Object)this.hashVal, (Object)entry);
            }
        }
    }

    public int getHashValue() {
        return this.hashVal;
    }

    public TreeNode getIteratorTree() {
        return this.tree;
    }

    public ASTJexlScript getAST() {
        return this.rootNode;
    }

    public Set<String> getNegatedTermsForOptimizer() {
        return this.negatedTerms;
    }

    public Set<String> getAndTermsForOptimizer() {
        return this.andTerms;
    }

    public Set<String> getOrTermsForOptimizer() {
        return this.orTerms;
    }

    public Set<Object> getQueryLiterals() {
        return this.literals;
    }

    public Set<String> getQueryIdentifiers() {
        return this.terms.keySet();
    }

    public Multimap<String, QueryTerm> getQueryTerms() {
        return this.terms;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTJexlScript node, Object data) {
        return null;
    }

    public Object visit(ASTBlock node, Object data) {
        return null;
    }

    public Object visit(ASTAmbiguous node, Object data) {
        return null;
    }

    public Object visit(ASTIfStatement node, Object data) {
        return null;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        return null;
    }

    public Object visit(ASTForeachStatement node, Object data) {
        return null;
    }

    public Object visit(ASTAssignment node, Object data) {
        return null;
    }

    public Object visit(ASTTernaryNode node, Object data) {
        return null;
    }

    public Object visit(ASTOrNode node, Object data) {
        boolean previouslyInOrContext = false;
        EvaluationContext ctx = null;
        if (null != data && data instanceof EvaluationContext) {
            ctx = (EvaluationContext)data;
            previouslyInOrContext = ctx.inOrContext;
        } else {
            ctx = new EvaluationContext();
        }
        ctx.inOrContext = true;
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)ctx);
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, (Object)ctx);
        if (null != data && !previouslyInOrContext) {
            ctx.inOrContext = false;
        }
        return null;
    }

    public Object visit(ASTAndNode node, Object data) {
        boolean previouslyInAndContext = false;
        EvaluationContext ctx = null;
        if (null != data && data instanceof EvaluationContext) {
            ctx = (EvaluationContext)data;
            previouslyInAndContext = ctx.inAndContext;
        } else {
            ctx = new EvaluationContext();
        }
        ctx.inAndContext = true;
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)ctx);
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, (Object)ctx);
        if (null != data && !previouslyInAndContext) {
            ctx.inAndContext = false;
        }
        return null;
    }

    public Object visit(ASTBitwiseOrNode node, Object data) {
        return null;
    }

    public Object visit(ASTBitwiseXorNode node, Object data) {
        return null;
    }

    public Object visit(ASTBitwiseAndNode node, Object data) {
        return null;
    }

    public Object visit(ASTEQNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTNENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = true;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                boolean bl = negated = !negated;
            }
        }
        if (negated) {
            this.negatedTerms.add(fieldName.toString());
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTLTNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTGTNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTLENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTGENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTERNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTNRNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        ObjectHolder value = new ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof FunctionResult || right instanceof FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = true;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                boolean bl = negated = !negated;
            }
        }
        if (negated) {
            this.negatedTerms.add(fieldName.toString());
        }
        QueryTerm term = new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.terms.put((Object)fieldName.toString(), (Object)term);
        return null;
    }

    public Object visit(ASTAdditiveNode node, Object data) {
        return null;
    }

    public Object visit(ASTAdditiveOperator node, Object data) {
        return null;
    }

    public Object visit(ASTMulNode node, Object data) {
        return null;
    }

    public Object visit(ASTDivNode node, Object data) {
        return null;
    }

    public Object visit(ASTModNode node, Object data) {
        return null;
    }

    public Object visit(ASTUnaryMinusNode node, Object data) {
        return null;
    }

    public Object visit(ASTBitwiseComplNode node, Object data) {
        return null;
    }

    public Object visit(ASTNotNode node, Object data) {
        boolean previouslyInNotContext = false;
        EvaluationContext ctx = null;
        if (null != data && data instanceof EvaluationContext) {
            ctx = (EvaluationContext)data;
            previouslyInNotContext = ctx.inNotContext;
        } else {
            ctx = new EvaluationContext();
        }
        ctx.inNotContext = true;
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)ctx);
        if (null != data && !previouslyInNotContext) {
            ctx.inNotContext = false;
        }
        return null;
    }

    public Object visit(ASTIdentifier node, Object data) {
        if (data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inAndContext) {
                this.andTerms.add(node.image);
            }
            if (ctx.inNotContext) {
                this.negatedTerms.add(node.image);
            }
            if (ctx.inOrContext) {
                this.orTerms.add(node.image);
            }
        }
        return new TermResult(node.image);
    }

    public Object visit(ASTNullLiteral node, Object data) {
        this.literals.add(node.image);
        return new LiteralResult(node.image);
    }

    public Object visit(ASTTrueNode node, Object data) {
        return new LiteralResult(node.image);
    }

    public Object visit(ASTFalseNode node, Object data) {
        return new LiteralResult(node.image);
    }

    public Object visit(ASTIntegerLiteral node, Object data) {
        this.literals.add(node.image);
        return new LiteralResult(node.image);
    }

    public Object visit(ASTFloatLiteral node, Object data) {
        this.literals.add(node.image);
        return new LiteralResult(node.image);
    }

    public Object visit(ASTStringLiteral node, Object data) {
        this.literals.add("'" + node.image + "'");
        return new LiteralResult("'" + node.image + "'");
    }

    public Object visit(ASTArrayLiteral node, Object data) {
        return null;
    }

    public Object visit(ASTMapLiteral node, Object data) {
        return null;
    }

    public Object visit(ASTMapEntry node, Object data) {
        return null;
    }

    public Object visit(ASTEmptyFunction node, Object data) {
        return null;
    }

    public Object visit(ASTSizeFunction node, Object data) {
        return null;
    }

    public Object visit(ASTFunctionNode node, Object data) {
        boolean negated = true;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        StringBuilder buf = new StringBuilder();
        String sep = "";
        buf.append(node.jjtGetChild((int)0).image).append(":");
        buf.append(node.jjtGetChild((int)1).image).append("(");
        FunctionResult fr = new FunctionResult();
        int argc = node.jjtGetNumChildren() - 2;
        for (int i = 0; i < argc; ++i) {
            Object result = node.jjtGetChild(i + 2).jjtAccept((ParserVisitor)this, data);
            if (result instanceof TermResult) {
                TermResult tr = (TermResult)result;
                fr.getTerms().add(tr);
                buf.append(sep).append(tr.value);
                sep = ", ";
                continue;
            }
            buf.append(sep).append(node.jjtGetChild((int)(i + 2)).image);
            sep = ", ";
        }
        buf.append(")");
        for (TermResult tr : fr.terms) {
            this.terms.put((Object)((String)tr.value), (Object)new QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), buf.toString()));
        }
        return fr;
    }

    public Object visit(ASTMethodNode node, Object data) {
        return null;
    }

    public Object visit(ASTSizeMethod node, Object data) {
        return null;
    }

    public Object visit(ASTConstructorNode node, Object data) {
        return null;
    }

    public Object visit(ASTArrayAccess node, Object data) {
        return null;
    }

    public Object visit(ASTReference node, Object data) {
        return node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decodeResults(Object left, Object right, StringBuilder fieldName, ObjectHolder holder) {
        if (left instanceof TermResult) {
            TermResult tr = (TermResult)left;
            fieldName.append((String)tr.value);
            if (!(right instanceof LiteralResult)) throw new IllegalArgumentException("Object mismatch");
            holder.setObject(((LiteralResult)right).value);
            return;
        } else {
            if (!(right instanceof TermResult)) throw new IllegalArgumentException("No Term specified in criteria");
            TermResult tr = (TermResult)right;
            fieldName.append((String)tr.value);
            if (!(left instanceof LiteralResult)) throw new IllegalArgumentException("Object mismatch");
            holder.setObject(((LiteralResult)left).value);
        }
    }

    private static class CacheEntry {
        private Set<String> negatedTerms = null;
        private Set<String> andTerms = null;
        private Set<String> orTerms = null;
        private Set<Object> literals = null;
        private Multimap<String, QueryTerm> terms = null;
        private ASTJexlScript rootNode = null;
        private TreeNode tree = null;

        public CacheEntry(Set<String> negatedTerms, Set<String> andTerms, Set<String> orTerms, Set<Object> literals, Multimap<String, QueryTerm> terms, ASTJexlScript rootNode, TreeNode tree) {
            this.negatedTerms = negatedTerms;
            this.andTerms = andTerms;
            this.orTerms = orTerms;
            this.literals = literals;
            this.terms = terms;
            this.rootNode = rootNode;
            this.tree = tree;
        }

        public Set<String> getNegatedTerms() {
            return this.negatedTerms;
        }

        public Set<String> getAndTerms() {
            return this.andTerms;
        }

        public Set<String> getOrTerms() {
            return this.orTerms;
        }

        public Set<Object> getLiterals() {
            return this.literals;
        }

        public Multimap<String, QueryTerm> getTerms() {
            return this.terms;
        }

        public ASTJexlScript getRootNode() {
            return this.rootNode;
        }

        public TreeNode getTree() {
            return this.tree;
        }
    }

    static class EvaluationContext {
        boolean inOrContext = false;
        boolean inNotContext = false;
        boolean inAndContext = false;

        EvaluationContext() {
        }
    }

    static class LiteralResult {
        Object value;

        public LiteralResult(Object value) {
            this.value = value;
        }
    }

    static class TermResult {
        Object value;

        public TermResult(Object value) {
            this.value = value;
        }
    }

    static class FunctionResult {
        private List<TermResult> terms = new ArrayList<TermResult>();

        FunctionResult() {
        }

        public List<TermResult> getTerms() {
            return this.terms;
        }
    }

    static class ObjectHolder {
        Object object;

        ObjectHolder() {
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }

    public static class QueryTerm {
        private boolean negated = false;
        private String operator = null;
        private Object value = null;

        public QueryTerm(boolean negated, String operator, Object value) {
            this.negated = negated;
            this.operator = operator;
            this.value = value;
        }

        public boolean isNegated() {
            return this.negated;
        }

        public void setNegated(boolean negated) {
            this.negated = negated;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("negated: ").append(this.negated).append(", operator: ").append(this.operator).append(", value: ").append(this.value);
            return buf.toString();
        }
    }
}

