/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.jexl2.parser.ASTAndNode;
import org.apache.commons.jexl2.parser.ASTEQNode;
import org.apache.commons.jexl2.parser.ASTERNode;
import org.apache.commons.jexl2.parser.ASTFalseNode;
import org.apache.commons.jexl2.parser.ASTFunctionNode;
import org.apache.commons.jexl2.parser.ASTGENode;
import org.apache.commons.jexl2.parser.ASTGTNode;
import org.apache.commons.jexl2.parser.ASTLENode;
import org.apache.commons.jexl2.parser.ASTLTNode;
import org.apache.commons.jexl2.parser.ASTNENode;
import org.apache.commons.jexl2.parser.ASTNRNode;
import org.apache.commons.jexl2.parser.ASTNullLiteral;
import org.apache.commons.jexl2.parser.ASTOrNode;
import org.apache.commons.jexl2.parser.ASTTrueNode;
import org.apache.commons.jexl2.parser.ParserVisitor;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.support.JexlOperatorConstants;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryParser;

public class RangeCalculator
extends QueryParser {
    protected static Logger log = Logger.getLogger(RangeCalculator.class);
    private static String WILDCARD = ".*";
    private static String SINGLE_WILDCARD = "\\.";
    protected Connector c;
    protected Authorizations auths;
    protected Multimap<String, QueryParser.QueryTerm> termsCopy = HashMultimap.create();
    protected String indexTableName;
    protected String reverseIndexTableName;
    protected int queryThreads = 8;
    protected Set<Range> result = null;
    protected Multimap<String, String> indexEntries = HashMultimap.create();
    protected Map<String, String> indexValues = new HashMap<String, String>();
    protected Multimap<String, MapKey> originalQueryValues = HashMultimap.create();
    protected Map<String, Long> termCardinalities = new HashMap<String, Long>();
    protected Map<MapKey, TermRange> globalIndexResults = new HashMap<MapKey, TermRange>();

    public Set<Range> getResult() {
        return this.result;
    }

    public Multimap<String, String> getIndexEntries() {
        return this.indexEntries;
    }

    public Map<String, String> getIndexValues() {
        return this.indexValues;
    }

    public Map<String, Long> getTermCardinalities() {
        return this.termCardinalities;
    }

    @Override
    public Object visit(ASTOrNode node, Object data) {
        boolean previouslyInOrContext = false;
        EvaluationContext ctx = null;
        if (null != data && data instanceof EvaluationContext) {
            ctx = (EvaluationContext)data;
            previouslyInOrContext = ctx.inOrContext;
        } else {
            ctx = new EvaluationContext();
        }
        ctx.inOrContext = true;
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)ctx);
        Long leftCardinality = this.termCardinalities.get(ctx.lastProcessedTerm);
        if (null == leftCardinality) {
            leftCardinality = 0L;
        }
        TermRange leftRange = ctx.lastRange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[OR-left] term: " + ctx.lastProcessedTerm + ", cardinality: " + leftCardinality + ", ranges: " + leftRange.getRanges().size()));
        }
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, (Object)ctx);
        Long rightCardinality = this.termCardinalities.get(ctx.lastProcessedTerm);
        if (null == rightCardinality) {
            rightCardinality = 0L;
        }
        TermRange rightRange = ctx.lastRange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[OR-right] term: " + ctx.lastProcessedTerm + ", cardinality: " + rightCardinality + ", ranges: " + rightRange.getRanges().size()));
        }
        if (null != data && !previouslyInOrContext) {
            ctx.inOrContext = false;
        }
        TreeSet<Range> ranges = new TreeSet<Range>();
        ranges.addAll(leftRange.getRanges());
        ranges.addAll(rightRange.getRanges());
        HashSet<Text> shardsAdded = new HashSet<Text>();
        HashSet<Range> returnSet = new HashSet<Range>();
        for (Range r : ranges) {
            if (!shardsAdded.contains(r.getStartKey().getRow())) {
                if (r.getStartKey().getColumnFamily() == null) {
                    shardsAdded.add(r.getStartKey().getRow());
                }
                returnSet.add(r);
                continue;
            }
            log.info((Object)("Skipping event specific range: " + r.toString() + " because shard range has already been added: " + shardsAdded.contains(r.getStartKey().getRow())));
        }
        TermRange orRange = new TermRange("OR_RESULT", "foo");
        orRange.addAll(returnSet);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[OR] results: " + orRange.getRanges().toString()));
        }
        ctx.lastRange = orRange;
        ctx.lastProcessedTerm = "OR_RESULT";
        this.termCardinalities.put("OR_RESULT", leftCardinality + rightCardinality);
        return null;
    }

    @Override
    public Object visit(ASTAndNode node, Object data) {
        boolean previouslyInAndContext = false;
        EvaluationContext ctx = null;
        if (null != data && data instanceof EvaluationContext) {
            ctx = (EvaluationContext)data;
            previouslyInAndContext = ctx.inAndContext;
        } else {
            ctx = new EvaluationContext();
        }
        ctx.inAndContext = true;
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)ctx);
        String leftTerm = ctx.lastProcessedTerm;
        Long leftCardinality = this.termCardinalities.get(leftTerm);
        if (null == leftCardinality) {
            leftCardinality = 0L;
        }
        TermRange leftRange = ctx.lastRange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[AND-left] term: " + ctx.lastProcessedTerm + ", cardinality: " + leftCardinality + ", ranges: " + leftRange.getRanges().size()));
        }
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, (Object)ctx);
        String rightTerm = ctx.lastProcessedTerm;
        Long rightCardinality = this.termCardinalities.get(rightTerm);
        if (null == rightCardinality) {
            rightCardinality = 0L;
        }
        TermRange rightRange = ctx.lastRange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[AND-right] term: " + ctx.lastProcessedTerm + ", cardinality: " + rightCardinality + ", ranges: " + rightRange.getRanges().size()));
        }
        if (null != data && !previouslyInAndContext) {
            ctx.inAndContext = false;
        }
        long card = 0L;
        TermRange andRange = new TermRange("AND_RESULT", "foo");
        if (leftCardinality > 0L && leftCardinality <= rightCardinality || rightCardinality == 0L) {
            card = leftCardinality;
            andRange.addAll(leftRange.getRanges());
        } else if (rightCardinality > 0L && rightCardinality <= leftCardinality || leftCardinality == 0L) {
            card = rightCardinality;
            andRange.addAll(rightRange.getRanges());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[AND] results: " + andRange.getRanges().toString()));
        }
        ctx.lastRange = andRange;
        ctx.lastProcessedTerm = "AND_RESULT";
        this.termCardinalities.put("AND_RESULT", card);
        return null;
    }

    @Override
    public Object visit(ASTEQNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTNENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = true;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                boolean bl = negated = !negated;
            }
        }
        if (negated) {
            this.negatedTerms.add(fieldName.toString());
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange(fieldName.toString(), term.getValue());
            ctx.lastProcessedTerm = fieldName.toString();
            this.termCardinalities.put(fieldName.toString(), 0L);
        }
        return null;
    }

    @Override
    public Object visit(ASTLTNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTGTNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTLENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTGENode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTERNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = false;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                negated = !negated;
            }
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        String termValue = null;
        termValue = ((String)term.getValue()).startsWith("'") && ((String)term.getValue()).endsWith("'") ? ((String)term.getValue()).substring(1, ((String)term.getValue()).length() - 1) : (String)term.getValue();
        TermRange ranges = null;
        for (MapKey key : this.originalQueryValues.get((Object)termValue)) {
            if (!key.getFieldName().equalsIgnoreCase(fieldName.toString())) continue;
            ranges = this.globalIndexResults.get(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Results for cached index ranges for key: " + key + " are " + ranges));
        }
        if (null == ranges) {
            ranges = new TermRange(fieldName.toString(), (String)term.getValue());
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = ranges;
            ctx.lastProcessedTerm = fieldName.toString();
        }
        return null;
    }

    @Override
    public Object visit(ASTNRNode node, Object data) {
        StringBuilder fieldName = new StringBuilder();
        QueryParser.ObjectHolder value = new QueryParser.ObjectHolder();
        Object left = node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        Object right = node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        if (left instanceof QueryParser.FunctionResult || right instanceof QueryParser.FunctionResult) {
            return null;
        }
        this.decodeResults(left, right, fieldName, value);
        boolean negated = true;
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            if (ctx.inNotContext) {
                boolean bl = negated = !negated;
            }
        }
        if (negated) {
            this.negatedTerms.add(fieldName.toString());
        }
        QueryParser.QueryTerm term = new QueryParser.QueryTerm(negated, JexlOperatorConstants.getOperator(node.getClass()), value.getObject());
        this.termsCopy.put((Object)fieldName.toString(), (Object)term);
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange(fieldName.toString(), term.getValue());
            ctx.lastProcessedTerm = fieldName.toString();
            this.termCardinalities.put(fieldName.toString(), 0L);
        }
        return null;
    }

    @Override
    public Object visit(ASTNullLiteral node, Object data) {
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange("null", "null");
            ctx.lastProcessedTerm = "null";
            this.termCardinalities.put("null", 0L);
        }
        return new QueryParser.LiteralResult(node.image);
    }

    @Override
    public Object visit(ASTTrueNode node, Object data) {
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange("true", "true");
            ctx.lastProcessedTerm = "true";
            this.termCardinalities.put("true", 0L);
        }
        return new QueryParser.LiteralResult(node.image);
    }

    @Override
    public Object visit(ASTFalseNode node, Object data) {
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange("false", "false");
            ctx.lastProcessedTerm = "false";
            this.termCardinalities.put("false", 0L);
        }
        return new QueryParser.LiteralResult(node.image);
    }

    @Override
    public Object visit(ASTFunctionNode node, Object data) {
        QueryParser.FunctionResult fr = new QueryParser.FunctionResult();
        int argc = node.jjtGetNumChildren() - 2;
        for (int i = 0; i < argc; ++i) {
            Object result = node.jjtGetChild(i + 2).jjtAccept((ParserVisitor)this, data);
            if (!(result instanceof QueryParser.TermResult)) continue;
            QueryParser.TermResult tr = (QueryParser.TermResult)result;
            fr.getTerms().add(tr);
            this.termsCopy.put((Object)((String)tr.value), null);
        }
        if (null != data && data instanceof EvaluationContext) {
            EvaluationContext ctx = (EvaluationContext)data;
            ctx.lastRange = new TermRange(node.jjtGetChild((int)0).image, node.jjtGetChild((int)1).image);
            ctx.lastProcessedTerm = node.jjtGetChild((int)0).image;
            this.termCardinalities.put(node.jjtGetChild((int)0).image, 0L);
        }
        return fr;
    }

    static class EvaluationContext {
        boolean inOrContext = false;
        boolean inNotContext = false;
        boolean inAndContext = false;
        TermRange lastRange = null;
        String lastProcessedTerm = null;

        EvaluationContext() {
        }
    }

    protected static class TermRange
    implements Comparable<TermRange> {
        private String fieldName = null;
        private Object fieldValue = null;
        private Set<Range> ranges = new TreeSet<Range>();

        public TermRange(String name, Object fieldValue) {
            this.fieldName = name;
            this.fieldValue = fieldValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getFieldValue() {
            return this.fieldValue;
        }

        public void addAll(Set<Range> r) {
            this.ranges.addAll(r);
        }

        public void add(Range r) {
            this.ranges.add(r);
        }

        public Set<Range> getRanges() {
            return this.ranges;
        }

        public String toString() {
            ToStringBuilder tsb = new ToStringBuilder((Object)this);
            tsb.append("fieldName", (Object)this.fieldName);
            tsb.append("fieldValue", this.fieldValue);
            tsb.append("ranges", this.ranges);
            return tsb.toString();
        }

        @Override
        public int compareTo(TermRange o) {
            int result = this.fieldName.compareTo(o.fieldName);
            if (result == 0) {
                return Integer.valueOf(this.ranges.size()).compareTo(o.ranges.size());
            }
            return result;
        }
    }

    public static class RangeBounds {
        private String originalLower = null;
        private Text lower = null;
        private String originalUpper = null;
        private Text upper = null;

        public Text getLower() {
            return this.lower;
        }

        public void setLower(Text lower) {
            this.lower = lower;
        }

        public Text getUpper() {
            return this.upper;
        }

        public void setUpper(Text upper) {
            this.upper = upper;
        }

        public String getOriginalLower() {
            return this.originalLower;
        }

        public void setOriginalLower(String originalLower) {
            this.originalLower = originalLower;
        }

        public String getOriginalUpper() {
            return this.originalUpper;
        }

        public void setOriginalUpper(String originalUpper) {
            this.originalUpper = originalUpper;
        }
    }

    public static class MapKey
    implements Comparable<MapKey> {
        private String fieldName = null;
        private String fieldValue = null;
        private String originalQueryValue = null;

        public MapKey(String fieldName, String fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String getOriginalQueryValue() {
            return this.originalQueryValue;
        }

        public void setOriginalQueryValue(String originalQueryValue) {
            this.originalQueryValue = originalQueryValue;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.fieldName).append((Object)this.fieldValue).toHashCode();
        }

        public String toString() {
            return this.fieldName + " " + this.fieldValue;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof MapKey) {
                MapKey o = (MapKey)other;
                return this.fieldName.equals(o.fieldName) && this.fieldValue.equals(o.fieldValue);
            }
            return false;
        }

        @Override
        public int compareTo(MapKey o) {
            int result = this.fieldName.compareTo(o.fieldName);
            if (result != 0) {
                return this.fieldValue.compareTo(o.fieldValue);
            }
            return result;
        }
    }
}

