/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators.support;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.jexl2.parser.JexlNode;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryParser;

public class TreeNode {
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new Enumeration<TreeNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public TreeNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    private Class<? extends JexlNode> type = null;
    private TreeNode parent = null;
    private List<TreeNode> children = new ArrayList<TreeNode>();
    private Multimap<String, QueryParser.QueryTerm> terms = HashMultimap.create();

    public Class<? extends JexlNode> getType() {
        return this.type;
    }

    public void setType(Class<? extends JexlNode> type) {
        this.type = type;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public Enumeration<TreeNode> getChildrenAsEnumeration() {
        return Collections.enumeration(this.children);
    }

    public Multimap<String, QueryParser.QueryTerm> getTerms() {
        return this.terms;
    }

    public void setTerms(Multimap<String, QueryParser.QueryTerm> terms) {
        this.terms = terms;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Type: ").append(this.type.getSimpleName());
        buf.append(" Terms: ");
        if (null == this.terms) {
            buf.append("null");
        } else {
            buf.append(this.terms.toString());
        }
        return buf.toString();
    }

    public final Enumeration<?> depthFirstEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration<?> breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    final class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration enumer = (Enumeration)this.queue.firstObject();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration<TreeNode> children = node.getChildrenAsEnumeration();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    public final class PostorderEnumeration
    implements Enumeration<TreeNode> {
        protected TreeNode root;
        protected Enumeration<TreeNode> children;
        protected Enumeration<TreeNode> subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.getChildrenAsEnumeration();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration(this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }
}

