/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.criteria;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.CardinalityReorderVisitor;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.ExtractInNotInVisitor;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.ExtractRangesVisitor;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.NoOrNotEqualsValidator;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.QueryKeysExtractorVisitor;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.RangeSplitterVisitor;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.criteria.visitor.CollapseParentClauseVisitor;
import org.calrissian.mango.criteria.visitor.EmptyParentCollapseVisitor;
import org.calrissian.mango.criteria.visitor.NodeVisitor;
import org.calrissian.mango.criteria.visitor.SingleClauseCollapseVisitor;
import org.calrissian.mango.types.TypeRegistry;

public class QueryOptimizer
implements NodeVisitor {
    protected Node node;
    protected Set<String> keysInQuery;
    protected GlobalIndexVisitor indexVisitor;
    protected TypeRegistry<String> typeRegistry;

    public QueryOptimizer(Node query, GlobalIndexVisitor indexVisitor, TypeRegistry<String> typeRegistry) {
        Preconditions.checkNotNull((Object)query);
        this.node = query.clone(null);
        this.indexVisitor = indexVisitor;
        this.typeRegistry = typeRegistry;
        this.init();
    }

    public QueryOptimizer(Node query, TypeRegistry<String> typeRegistry) {
        this(query, null, typeRegistry);
    }

    protected void init() {
        if (!NodeUtils.isEmpty((Node)this.node)) {
            this.node.accept((NodeVisitor)new ExtractInNotInVisitor());
            if (this.indexVisitor != null) {
                this.node.accept((NodeVisitor)this.indexVisitor);
                this.indexVisitor.exec();
                this.node.accept((NodeVisitor)new CardinalityReorderVisitor(this.indexVisitor.getCardinalities(), this.typeRegistry));
            }
            Node previous = this.node.clone(null);
            while (!previous.equals(this.node)) {
                this.runOptimizations(this.node);
                previous = this.node.clone(null);
            }
        }
    }

    protected void runOptimizations(Node query) {
        query.accept((NodeVisitor)new SingleClauseCollapseVisitor());
        query.accept((NodeVisitor)new EmptyParentCollapseVisitor());
        query.accept((NodeVisitor)new CollapseParentClauseVisitor());
        query.accept((NodeVisitor)new RangeSplitterVisitor());
        ExtractRangesVisitor extractRangesVisitor = new ExtractRangesVisitor();
        query.accept((NodeVisitor)extractRangesVisitor);
        extractRangesVisitor.extract();
        query.accept((NodeVisitor)new NoOrNotEqualsValidator());
        QueryKeysExtractorVisitor extractKeysVisitor = new QueryKeysExtractorVisitor();
        query.accept((NodeVisitor)extractKeysVisitor);
        this.keysInQuery = extractKeysVisitor.getKeysFound();
        query.accept((NodeVisitor)this);
    }

    public Node getOptimizedQuery() {
        return this.node;
    }

    public Set<String> getKeysInQuery() {
        return this.keysInQuery;
    }

    public void begin(ParentNode node) {
    }

    public void end(ParentNode parentNode) {
    }

    public void visit(Leaf node) {
    }

    public Set<String> getShards() {
        if (this.indexVisitor != null) {
            return this.indexVisitor.getShards();
        }
        throw new RuntimeException("A global index visitor was not configured on this optimizer.");
    }
}

