/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.criteria.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.calrissian.accumulorecipes.commons.support.criteria.BaseCardinalityKey;
import org.calrissian.accumulorecipes.commons.support.criteria.CardinalityKey;
import org.calrissian.mango.criteria.domain.AbstractKeyValueLeaf;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.NegationLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.criteria.visitor.NodeVisitor;
import org.calrissian.mango.types.TypeRegistry;

public class CardinalityReorderVisitor
implements NodeVisitor {
    private static TypeRegistry<String> registry;
    private Map<CardinalityKey, Long> cardinalities;
    private Map<String, Set<CardinalityKey>> keyToCarinalityKey = new HashMap<String, Set<CardinalityKey>>();

    public CardinalityReorderVisitor(Map<CardinalityKey, Long> cardinalities, TypeRegistry<String> typeRegistry) {
        this.cardinalities = cardinalities;
        registry = typeRegistry;
        for (CardinalityKey key : cardinalities.keySet()) {
            Set<CardinalityKey> cardinalityKey = this.keyToCarinalityKey.get(key.getKey());
            if (cardinalityKey == null) {
                cardinalityKey = new HashSet<CardinalityKey>();
                this.keyToCarinalityKey.put(key.getKey(), cardinalityKey);
            }
            cardinalityKey.add(key);
        }
    }

    public void begin(ParentNode parentNode) {
        ArrayList<CardinalityNode> newCardinalities = new ArrayList<CardinalityNode>();
        long totalCardinality = 0L;
        for (Node child : parentNode.children()) {
            CardinalityNode cardinalityNode = null;
            if (child instanceof AndNode || child instanceof OrNode) {
                cardinalityNode = new CardinalityNode(this.getCardinality((ParentNode)child), child);
            } else if (child instanceof Leaf) {
                cardinalityNode = new CardinalityNode(this.getCardinality((Leaf)child), child);
            } else {
                throw new RuntimeException("Unexpected node encountered while calculating cardinalities: " + child.getClass());
            }
            if (parentNode instanceof AndNode && cardinalityNode.cardinality == 0L) {
                if (parentNode.parent() != null) {
                    parentNode.parent().removeChild((Node)parentNode);
                    break;
                }
                parentNode.children().clear();
                break;
            }
            newCardinalities.add(cardinalityNode);
            totalCardinality += cardinalityNode.cardinality.longValue();
        }
        if (parentNode instanceof OrNode && totalCardinality == 0L) {
            if (parentNode.parent() != null) {
                parentNode.parent().removeChild((Node)parentNode);
            } else {
                parentNode.children().clear();
            }
        } else {
            Collections.sort(newCardinalities);
            parentNode.children().clear();
            for (CardinalityNode cnode : newCardinalities) {
                parentNode.addChild(cnode.getNode());
            }
        }
    }

    private long getCardinality(ParentNode node) {
        long cardinality = 0L;
        for (Node child : node.children()) {
            if (child instanceof AndNode || child instanceof OrNode) {
                cardinality += this.getCardinality((ParentNode)child);
                continue;
            }
            if (child instanceof Leaf) {
                cardinality += this.getCardinality((Leaf)child);
                continue;
            }
            throw new RuntimeException("Unexpected node encountered while calculating cardinalities: " + child.getClass());
        }
        return cardinality;
    }

    private long getCardinality(Leaf leaf) {
        AbstractKeyValueLeaf kvLeaf = (AbstractKeyValueLeaf)leaf;
        if (leaf instanceof HasLeaf || leaf instanceof HasNotLeaf || NodeUtils.isRangeLeaf((Leaf)leaf)) {
            Set<CardinalityKey> cardinalityKeys = this.keyToCarinalityKey.get(kvLeaf.getKey());
            Long cardinality = 0L;
            if (cardinalityKeys == null) {
                if (leaf instanceof NegationLeaf) {
                    return 1L;
                }
            } else {
                for (CardinalityKey key : cardinalityKeys) {
                    cardinality = cardinality + this.cardinalities.get(key);
                }
            }
            return cardinality;
        }
        String alias = registry.getAlias(kvLeaf.getValue());
        String normalizedVal = null;
        normalizedVal = (String)registry.encode(kvLeaf.getValue());
        BaseCardinalityKey cardinalityKey = new BaseCardinalityKey(kvLeaf.getKey(), normalizedVal, alias);
        Long cardinality = this.cardinalities.get(cardinalityKey);
        if (cardinality == null && leaf instanceof NegationLeaf) {
            return 1L;
        }
        return cardinality != null ? cardinality : 0L;
    }

    public void end(ParentNode parentNode) {
    }

    public void visit(Leaf leaf) {
    }

    private class CardinalityNode
    implements Comparable<CardinalityNode> {
        private Long cardinality;
        private Node node;

        private CardinalityNode(Long cardinality, Node node) {
            this.cardinality = cardinality;
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        @Override
        public int compareTo(CardinalityNode o) {
            return this.cardinality.compareTo(o.cardinality);
        }
    }
}

