/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.criteria.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.criteria.visitor.NodeVisitor;

public class ExtractRangesVisitor
implements NodeVisitor {
    private boolean nonRangeFound = false;
    private List<Leaf> rangeNodes = new LinkedList<Leaf>();

    public void begin(ParentNode parentNode) {
    }

    public void end(ParentNode parentNode) {
    }

    public void extract() {
        if (this.rangeNodes.size() > 0) {
            Iterator<Leaf> nodeIter = this.rangeNodes.iterator();
            if (!this.nonRangeFound) {
                nodeIter.next();
            }
            while (nodeIter.hasNext()) {
                Leaf leaf = nodeIter.next();
                leaf.parent().removeChild((Node)leaf);
            }
        }
    }

    public void visit(Leaf leaf) {
        if (NodeUtils.isRangeLeaf((Leaf)leaf)) {
            this.rangeNodes.add(leaf);
        } else {
            this.nonRangeFound = true;
        }
    }
}

