/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.mango.types.TypeRegistry;

public class SimpleMetadataSerDe
implements MetadataSerDe {
    private TypeRegistry<String> typeRegistry;

    public SimpleMetadataSerDe(TypeRegistry<String> typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public byte[] serialize(Map<String, Object> metadata) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(baos);
            int count = 0;
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                if (entry.getValue() == null) continue;
                ++count;
            }
            dataOutput.writeInt(count);
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                dataOutput.writeUTF(entry.getKey());
                dataOutput.writeUTF(this.typeRegistry.getAlias(entry.getValue()));
                dataOutput.writeUTF((String)this.typeRegistry.encode(entry.getValue()));
            }
            byte[] bytes = baos.toByteArray();
            baos.flush();
            baos.close();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> deserialize(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            int count = dis.readInt();
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                String key = dis.readUTF();
                String alias = dis.readUTF();
                String encodedVal = dis.readUTF();
                metadata.put(key, this.typeRegistry.decode(alias, (Object)encodedVal));
            }
            bais.close();
            dis.close();
            return metadata;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

