/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.qfd;

import org.apache.accumulo.core.data.Value;

public class GlobalIndexValue {
    private final long cardinatlity;
    private final long expiration;

    public GlobalIndexValue(Value value) {
        String str = new String(value.get());
        int idx = str.indexOf(",");
        if (idx == -1) {
            this.cardinatlity = Long.parseLong(str);
            this.expiration = -1L;
        } else {
            this.cardinatlity = Long.parseLong(str.substring(0, idx));
            this.expiration = Long.parseLong(str.substring(idx + 1, str.length()));
        }
    }

    public GlobalIndexValue(long cardinality, long expiration) {
        this.cardinatlity = cardinality;
        this.expiration = expiration;
    }

    public long getCardinatlity() {
        return this.cardinatlity;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Value toValue() {
        return new Value((Long.toString(this.cardinatlity) + "," + Long.toString(this.expiration)).getBytes());
    }
}

