/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.qfd;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.iterators.GlobalIndexCombiner;
import org.calrissian.accumulorecipes.commons.iterators.GlobalIndexExpirationFilter;
import org.calrissian.accumulorecipes.commons.iterators.MetadataExpirationFilter;
import org.calrissian.accumulorecipes.commons.iterators.OptimizedQueryIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.iterators.support.NodeToJexl;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.commons.support.criteria.QueryOptimizer;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.metadata.SimpleMetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.qfd.KeyValueIndex;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.types.TypeRegistry;

public abstract class QfdHelper<T extends TupleStore> {
    private static final Kryo kryo = new Kryo();
    private final Connector connector;
    private final String indexTable;
    private final String shardTable;
    private final StoreConfig config;
    private final BatchWriter shardWriter;
    private final NodeToJexl nodeToJexl;
    private ShardBuilder<T> shardBuilder;
    private TypeRegistry<String> typeRegistry;
    private MetadataSerDe metadataSerDe;
    private KeyValueIndex<T> keyValueIndex;

    public QfdHelper(Connector connector, String indexTable, String shardTable, StoreConfig config, ShardBuilder<T> shardBuilder, TypeRegistry<String> typeRegistry, KeyValueIndex<T> keyValueIndex, MetadataSerDe metadataSerDe) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)indexTable);
        Preconditions.checkNotNull((Object)shardTable);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(shardBuilder);
        Preconditions.checkNotNull(typeRegistry);
        Preconditions.checkNotNull(keyValueIndex);
        Preconditions.checkNotNull((Object)metadataSerDe);
        this.connector = connector;
        this.indexTable = indexTable;
        this.shardTable = shardTable;
        this.typeRegistry = typeRegistry;
        this.config = config;
        this.shardBuilder = shardBuilder;
        this.typeRegistry = typeRegistry;
        this.keyValueIndex = keyValueIndex;
        this.nodeToJexl = new NodeToJexl(typeRegistry);
        this.metadataSerDe = metadataSerDe;
        if (!connector.tableOperations().exists(this.indexTable)) {
            connector.tableOperations().create(this.indexTable);
            this.configureIndexTable(connector, this.indexTable);
        }
        if (connector.tableOperations().getIteratorSetting(this.indexTable, "cardinalities", IteratorUtil.IteratorScope.majc) == null) {
            IteratorSetting setting = new IteratorSetting(10, "cardinalities", GlobalIndexCombiner.class);
            GlobalIndexCombiner.setCombineAllColumns((IteratorSetting)setting, (boolean)true);
            connector.tableOperations().attachIterator(this.indexTable, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
            IteratorSetting expirationFilter = new IteratorSetting(12, "expiration", GlobalIndexExpirationFilter.class);
            connector.tableOperations().attachIterator(this.indexTable, expirationFilter, EnumSet.allOf(IteratorUtil.IteratorScope.class));
        }
        if (!connector.tableOperations().exists(this.shardTable)) {
            connector.tableOperations().create(this.shardTable);
            this.configureShardTable(connector, this.shardTable);
            IteratorSetting expirationFilter = new IteratorSetting(10, "expiration", MetadataExpirationFilter.class);
            MetadataExpirationFilter.setMetadataSerde(expirationFilter, metadataSerDe);
            connector.tableOperations().attachIterator(this.shardTable, expirationFilter, EnumSet.allOf(IteratorUtil.IteratorScope.class));
        }
        EventFields.initializeKryo(kryo);
        this.shardWriter = connector.createBatchWriter(shardTable, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    public QfdHelper(Connector connector, String indexTable, String shardTable, StoreConfig config, ShardBuilder<T> shardBuilder, TypeRegistry<String> typeRegistry, KeyValueIndex<T> keyValueIndex) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this(connector, indexTable, shardTable, config, shardBuilder, typeRegistry, keyValueIndex, new SimpleMetadataSerDe(typeRegistry));
    }

    public MetadataSerDe getMetadataSerDe() {
        return this.metadataSerDe;
    }

    public static Kryo getKryo() {
        return kryo;
    }

    public void save(Iterable<? extends T> items) {
        Preconditions.checkNotNull(items);
        try {
            for (TupleStore item : items) {
                if (item.getTuples() == null || item.getTuples().isEmpty()) continue;
                String shardId = this.shardBuilder.buildShard(item);
                Mutation shardMutation = new Mutation((CharSequence)shardId);
                for (Tuple tuple : item.getTuples()) {
                    String aliasValue = this.typeRegistry.getAlias(tuple.getValue()) + "\u0001" + (String)this.typeRegistry.encode(tuple.getValue());
                    ColumnVisibility columnVisibility = new ColumnVisibility(Metadata.Visiblity.getVisibility(tuple, ""));
                    HashMap<String, Object> metadata = new HashMap<String, Object>(tuple.getMetadata());
                    metadata.remove("visibility");
                    shardMutation.put(new Text(this.buildId(item)), new Text(tuple.getKey() + "\u0000" + aliasValue), columnVisibility, this.buildTimestamp(item), new Value(this.metadataSerDe.serialize(metadata)));
                    shardMutation.put(new Text("fi\u0000" + tuple.getKey()), new Text(aliasValue + "\u0000" + this.buildId(item)), columnVisibility, this.buildTimestamp(item), new Value(this.metadataSerDe.serialize(metadata)));
                }
                this.shardWriter.addMutation(shardMutation);
            }
            this.shardWriter.flush();
            this.keyValueIndex.indexKeyValues(items);
            this.keyValueIndex.commit();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CloseableIterable<T> query(BatchScanner scanner, GlobalIndexVisitor globalIndexVisitor, Node query, Function<Map.Entry<Key, Value>, T> transform, Auths auths) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)auths);
        QueryOptimizer optimizer = new QueryOptimizer(query, globalIndexVisitor, this.typeRegistry);
        if (NodeUtils.isEmpty((Node)optimizer.getOptimizedQuery())) {
            return CloseableIterables.wrap((Iterable)Collections.EMPTY_LIST);
        }
        String jexl = this.nodeToJexl.transform(optimizer.getOptimizedQuery());
        String originalJexl = this.nodeToJexl.transform(query);
        Set<String> shards = optimizer.getShards();
        HashSet<Range> ranges = new HashSet<Range>();
        if (jexl.equals("()") || jexl.equals("")) {
            ranges.add(new Range((CharSequence)"\uffff"));
        } else {
            for (String shard : shards) {
                ranges.add(new Range((CharSequence)shard));
            }
        }
        scanner.setRanges(ranges);
        IteratorSetting setting = new IteratorSetting(16, OptimizedQueryIterator.class);
        setting.addOption("expr", originalJexl);
        setting.addOption("FIELD_INDEX_QUERY", jexl);
        scanner.addScanIterator(setting);
        return CloseableIterables.transform(Scanners.closeableIterable((ScannerBase)scanner), transform);
    }

    public void shutdown() {
        try {
            this.getWriter().close();
        }
        catch (MutationsRejectedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void configureIndexTable(Connector var1, String var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    protected abstract void configureShardTable(Connector var1, String var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    protected abstract String buildId(T var1);

    protected abstract Value buildValue(T var1);

    protected abstract long buildTimestamp(T var1);

    public BatchScanner buildIndexScanner(Authorizations auths) {
        return this.buildScanner(this.indexTable, auths);
    }

    public BatchScanner buildShardScanner(Authorizations auths) {
        return this.buildScanner(this.shardTable, auths);
    }

    private BatchScanner buildScanner(String table, Authorizations authorizations) {
        try {
            return this.connector.createBatchScanner(table, authorizations, this.config.getMaxQueryThreads());
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ShardBuilder getShardBuilder() {
        return this.shardBuilder;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public String getIndexTable() {
        return this.indexTable;
    }

    public String getShardTable() {
        return this.shardTable;
    }

    public StoreConfig getConfig() {
        return this.config;
    }

    public BatchWriter getWriter() {
        return this.shardWriter;
    }

    public TypeRegistry<String> getTypeRegistry() {
        return this.typeRegistry;
    }
}

