/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support.tuple;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;

public class MetadataBuilder {
    protected final Map<String, Object> metadata;

    public MetadataBuilder() {
        this(new HashMap<String, Object>());
    }

    public MetadataBuilder(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public MetadataBuilder setVisibility(String visibility) {
        Metadata.Visiblity.setVisibility(this.metadata, visibility);
        return this;
    }

    public MetadataBuilder setCustom(String key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.length() > 0 ? 1 : 0) != 0, (Object)"Not allowed to use an empty Metadata key");
        if (value != null) {
            this.metadata.put(key, value);
        }
        return this;
    }

    public Map<String, Object> build() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

