/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.transform;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.types.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyToTupleCollectionQueryXform<V extends TupleStore>
implements Function<Map.Entry<Key, Value>, V> {
    public static final Logger log = LoggerFactory.getLogger(KeyToTupleCollectionQueryXform.class);
    private Set<String> selectFields;
    private Kryo kryo;
    private TypeRegistry<String> typeRegistry;
    private MetadataSerDe metadataSerDe;

    public KeyToTupleCollectionQueryXform(Kryo kryo, TypeRegistry<String> typeRegistry, Set<String> selectFields, MetadataSerDe metadataSerDe) {
        this.selectFields = selectFields;
        this.kryo = kryo;
        this.typeRegistry = typeRegistry;
        this.metadataSerDe = metadataSerDe;
    }

    protected Set<String> getSelectFields() {
        return this.selectFields;
    }

    protected Kryo getKryo() {
        return this.kryo;
    }

    protected TypeRegistry<String> getTypeRegistry() {
        return this.typeRegistry;
    }

    public V apply(Map.Entry<Key, Value> keyValueEntry) {
        EventFields eventFields = new EventFields();
        eventFields.readObjectData(this.kryo, ByteBuffer.wrap(keyValueEntry.getValue().get()));
        V entry = this.buildTupleCollectionFromKey(keyValueEntry.getKey());
        for (Map.Entry fieldValue : eventFields.entries()) {
            if (this.selectFields != null && !this.selectFields.contains(fieldValue.getKey())) continue;
            String[] aliasVal = StringUtils.splitPreserveAllTokens((String)new String(((EventFields.FieldValue)fieldValue.getValue()).getValue()), (String)"\u0001");
            Object javaVal = this.typeRegistry.decode(aliasVal[0], (Object)aliasVal[1]);
            String vis = ((EventFields.FieldValue)fieldValue.getValue()).getVisibility().getExpression().length > 0 ? new String(((EventFields.FieldValue)fieldValue.getValue()).getVisibility().getExpression()) : "";
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            try {
                Map<String, Object> meta = this.metadataSerDe.deserialize(((EventFields.FieldValue)fieldValue.getValue()).getMetadata());
                if (meta != null) {
                    metadata.putAll(meta);
                }
            }
            catch (Exception e) {
                log.error("There was an error deserializing the metadata for a tuple", (Throwable)e);
            }
            Metadata.Visiblity.setVisibility(metadata, vis);
            Tuple tuple = new Tuple((String)fieldValue.getKey(), javaVal, metadata);
            entry.put(tuple);
        }
        return entry;
    }

    protected abstract V buildTupleCollectionFromKey(Key var1);
}

