/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.transform;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.commons.iterators.WholeColumnFamilyIterator;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.types.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyToTupleCollectionWholeColFXform<V extends TupleStore>
implements Function<Map.Entry<Key, Value>, V> {
    public static final Logger log = LoggerFactory.getLogger(KeyToTupleCollectionWholeColFXform.class);
    private Set<String> selectFields;
    private Kryo kryo;
    private TypeRegistry<String> typeRegistry;
    private MetadataSerDe metadataSerDe;

    public KeyToTupleCollectionWholeColFXform(Kryo kryo, TypeRegistry<String> typeRegistry, Set<String> selectFields, MetadataSerDe metadataSerDe) {
        this.selectFields = selectFields;
        this.kryo = kryo;
        this.typeRegistry = typeRegistry;
        this.metadataSerDe = metadataSerDe;
    }

    protected Set<String> getSelectFields() {
        return this.selectFields;
    }

    protected Kryo getKryo() {
        return this.kryo;
    }

    public V apply(Map.Entry<Key, Value> keyValueEntry) {
        try {
            SortedMap<Key, Value> keyValues = WholeColumnFamilyIterator.decodeRow(keyValueEntry.getKey(), keyValueEntry.getValue());
            V entry = null;
            for (Map.Entry curEntry : keyValues.entrySet()) {
                if (entry == null) {
                    entry = this.buildEntryFromKey((Key)curEntry.getKey());
                }
                String[] colQParts = StringUtils.splitPreserveAllTokens((String)((Key)curEntry.getKey()).getColumnQualifier().toString(), (String)"\u0000");
                String[] aliasValue = StringUtils.splitPreserveAllTokens((String)colQParts[1], (String)"\u0001");
                String visibility = ((Key)curEntry.getKey()).getColumnVisibility().toString();
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                try {
                    Map<String, Object> meta = this.metadataSerDe.deserialize(((Value)curEntry.getValue()).get());
                    if (meta != null) {
                        metadata.putAll(meta);
                    }
                }
                catch (Exception e) {
                    log.error("There was an error deserializing metadata for tuple.", (Throwable)e);
                }
                Metadata.Visiblity.setVisibility(metadata, visibility);
                Tuple tuple = new Tuple(colQParts[0], this.typeRegistry.decode(aliasValue[0], (Object)aliasValue[1]), metadata);
                entry.put(tuple);
            }
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract V buildEntryFromKey(Key var1);
}

