/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.iterators.EventFieldsFilteringIterator;
import org.calrissian.accumulorecipes.commons.iterators.FirstEntryInColumnIterator;
import org.calrissian.accumulorecipes.commons.iterators.WholeColumnFamilyIterator;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.entitystore.EntityStore;
import org.calrissian.accumulorecipes.entitystore.support.EntityCardinalityKey;
import org.calrissian.accumulorecipes.entitystore.support.EntityGlobalIndexVisitor;
import org.calrissian.accumulorecipes.entitystore.support.EntityKeyValueIndex;
import org.calrissian.accumulorecipes.entitystore.support.EntityQfdHelper;
import org.calrissian.accumulorecipes.entitystore.support.EntityShardBuilder;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.Pair;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIndex;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class AccumuloEntityStore
implements EntityStore {
    public static final String DEFAULT_IDX_TABLE_NAME = "entity_index";
    public static final String DEFAULT_SHARD_TABLE_NAME = "entity_shard";
    private static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(3, 100000L, 10000L, 3);
    public static final EntityShardBuilder DEFAULT_SHARD_BUILDER = new EntityShardBuilder(7);
    private final EntityShardBuilder shardBuilder;
    private final EntityQfdHelper helper;

    public AccumuloEntityStore(Connector connector) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this(connector, DEFAULT_IDX_TABLE_NAME, DEFAULT_SHARD_TABLE_NAME, DEFAULT_SHARD_BUILDER, DEFAULT_STORE_CONFIG, (TypeRegistry<String>)LexiTypeEncoders.LEXI_TYPES);
    }

    public AccumuloEntityStore(Connector connector, String indexTable, String shardTable, EntityShardBuilder shardBuilder, StoreConfig config, TypeRegistry<String> typeRegistry) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)indexTable);
        Preconditions.checkNotNull((Object)shardTable);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(typeRegistry);
        Preconditions.checkNotNull((Object)shardBuilder);
        EntityKeyValueIndex keyValueIndex = new EntityKeyValueIndex(connector, indexTable, shardBuilder, config, typeRegistry);
        this.shardBuilder = shardBuilder;
        this.helper = new EntityQfdHelper(connector, indexTable, shardTable, config, shardBuilder, typeRegistry, keyValueIndex);
    }

    @Override
    public void shutdown() throws MutationsRejectedException {
        this.helper.shutdown();
    }

    @Override
    public void save(Iterable<? extends Entity> entities) {
        this.helper.save(entities);
    }

    @Override
    public CloseableIterable<Entity> get(List<EntityIndex> typesAndIds, Set<String> selectFields, Auths auths) {
        Preconditions.checkNotNull(typesAndIds);
        Preconditions.checkNotNull((Object)auths);
        try {
            BatchScanner scanner = this.helper.buildShardScanner(auths.getAuths());
            LinkedList<Range> ranges = new LinkedList<Range>();
            for (EntityIndex curIndex : typesAndIds) {
                String shardId = this.shardBuilder.buildShard(curIndex.getType(), curIndex.getId());
                ranges.add(Range.exact((CharSequence)shardId, (CharSequence)(curIndex.getType() + "\u0001" + curIndex.getId())));
            }
            scanner.setRanges(ranges);
            IteratorSetting iteratorSetting = new IteratorSetting(16, "wholeColumnFamilyIterator", WholeColumnFamilyIterator.class);
            scanner.addScanIterator(iteratorSetting);
            if (selectFields != null && selectFields.size() > 0) {
                iteratorSetting = new IteratorSetting(15, EventFieldsFilteringIterator.class);
                EventFieldsFilteringIterator.setSelectFields((IteratorSetting)iteratorSetting, selectFields);
                scanner.addScanIterator(iteratorSetting);
            }
            return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), (Function)this.helper.buildWholeColFXform(selectFields));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterable<Entity> getAllByType(Set<String> types, Set<String> selectFields, Auths auths) {
        Preconditions.checkNotNull(types);
        Preconditions.checkNotNull((Object)auths);
        try {
            BatchScanner scanner = this.helper.buildShardScanner(auths.getAuths());
            LinkedList<Range> ranges = new LinkedList<Range>();
            for (String type : types) {
                Set<Text> shards = this.shardBuilder.buildShardsForTypes(Collections.singleton(type));
                for (Text shard : shards) {
                    ranges.add(Range.prefix((CharSequence)shard.toString(), (CharSequence)type));
                }
            }
            scanner.setRanges(ranges);
            IteratorSetting iteratorSetting = new IteratorSetting(16, "wholeColumnFamilyIterator", WholeColumnFamilyIterator.class);
            scanner.addScanIterator(iteratorSetting);
            if (selectFields != null && selectFields.size() > 0) {
                iteratorSetting = new IteratorSetting(15, EventFieldsFilteringIterator.class);
                EventFieldsFilteringIterator.setSelectFields((IteratorSetting)iteratorSetting, selectFields);
                scanner.addScanIterator(iteratorSetting);
            }
            return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), (Function)this.helper.buildWholeColFXform(selectFields));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterable<Entity> query(Set<String> types, Node query, Set<String> selectFields, Auths auths) {
        Preconditions.checkNotNull(types);
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)auths);
        Preconditions.checkArgument((types.size() > 0 ? 1 : 0) != 0);
        BatchScanner indexScanner = this.helper.buildIndexScanner(auths.getAuths());
        EntityGlobalIndexVisitor globalIndexVisitor = new EntityGlobalIndexVisitor(indexScanner, this.shardBuilder, types);
        BatchScanner scanner = this.helper.buildShardScanner(auths.getAuths());
        CloseableIterable entities = this.helper.query(scanner, globalIndexVisitor, query, (Function)this.helper.buildQueryXform(selectFields), auths);
        indexScanner.close();
        return entities;
    }

    @Override
    public CloseableIterable<Pair<String, String>> keys(String type, Auths auths) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)auths);
        BatchScanner scanner = this.helper.buildIndexScanner(auths.getAuths());
        IteratorSetting setting = new IteratorSetting(15, FirstEntryInColumnIterator.class);
        scanner.addScanIterator(setting);
        scanner.setRanges(Collections.singletonList(Range.prefix((CharSequence)(type + "_" + "k" + "_"))));
        return CloseableIterables.transform((CloseableIterable)CloseableIterables.wrap((Iterable)scanner), (Function)new Function<Map.Entry<Key, Value>, Pair<String, String>>(){

            public Pair<String, String> apply(Map.Entry<Key, Value> keyValueEntry) {
                EntityCardinalityKey key = new EntityCardinalityKey(keyValueEntry.getKey());
                return new Pair((Object)key.getKey(), (Object)key.getAlias());
            }
        });
    }

    @Override
    public void delete(Iterable<EntityIndex> typesAndIds, Auths auths) {
        throw new NotImplementedException();
    }

    protected EntityQfdHelper getHelper() {
        return this.helper;
    }
}

