/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.qfd.GlobalIndexValue;
import org.calrissian.accumulorecipes.commons.support.qfd.KeyValueIndex;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.types.TypeRegistry;

public class EntityKeyValueIndex
implements KeyValueIndex<Entity> {
    private final ShardBuilder<Entity> shardBuilder;
    private final TypeRegistry<String> typeRegistry;
    private final BatchWriter writer;

    public EntityKeyValueIndex(Connector connector, String indexTable, ShardBuilder<Entity> shardBuilder, StoreConfig config, TypeRegistry<String> typeRegistry) throws TableNotFoundException {
        this.shardBuilder = shardBuilder;
        this.typeRegistry = typeRegistry;
        this.writer = connector.createBatchWriter(indexTable, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    public void indexKeyValues(Iterable<? extends Entity> items) {
        HashMap<String, Long> indexCache = new HashMap<String, Long>();
        HashMap<String, Long> expirationCache = new HashMap<String, Long>();
        for (Entity entity : items) {
            String shardId = this.shardBuilder.buildShard((TupleStore)entity);
            for (Tuple tuple : entity.getTuples()) {
                Long curExpiration;
                Long expiration;
                Object[] strings = new String[]{entity.getType(), shardId, tuple.getKey(), this.typeRegistry.getAlias(tuple.getValue()), (String)this.typeRegistry.encode(tuple.getValue()), Metadata.Visiblity.getVisibility((Tuple)tuple, (String)"")};
                String cacheKey = StringUtils.join((Object[])strings, (String)"\u0001");
                Long count = (Long)indexCache.get(cacheKey);
                if (count == null) {
                    count = 0L;
                }
                if ((expiration = (Long)expirationCache.get(cacheKey)) == null) {
                    expiration = 0L;
                }
                expiration = (curExpiration = Metadata.Expiration.getExpiration((Map)tuple.getMetadata(), (long)-1L)) == -1L ? Long.valueOf(-1L) : Long.valueOf(Math.max(expiration, curExpiration));
                count = count + 1L;
                indexCache.put(cacheKey, count);
                expirationCache.put(cacheKey, expiration);
            }
        }
        for (Map.Entry entry : indexCache.entrySet()) {
            String[] indexParts = StringUtils.splitPreserveAllTokens((String)((String)entry.getKey()), (String)"\u0001");
            String entityType = indexParts[0];
            String shard = indexParts[1];
            String key = indexParts[2];
            String alias = indexParts[3];
            String normalizedVal = indexParts[4];
            String vis = indexParts[5];
            Mutation keyMutation = new Mutation((CharSequence)(entityType + "_" + "k" + "_" + key));
            Mutation valueMutation = new Mutation((CharSequence)(entityType + "_" + "v" + "_" + alias + "__" + normalizedVal));
            GlobalIndexValue indexValue = new GlobalIndexValue(((Long)entry.getValue()).longValue(), ((Long)expirationCache.get(entry.getKey())).longValue());
            Value value = indexValue.toValue();
            keyMutation.put(new Text(alias), new Text(shard), new ColumnVisibility(vis), value);
            valueMutation.put(new Text(key), new Text(shard), new ColumnVisibility(vis), value);
            try {
                this.writer.addMutation(keyMutation);
                this.writer.addMutation(valueMutation);
            }
            catch (MutationsRejectedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void commit() throws Exception {
        this.writer.flush();
    }

    public void shutdown() throws Exception {
        this.writer.close();
    }
}

