/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.support;

import com.esotericsoftware.kryo.Kryo;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.Constants;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.qfd.KeyValueIndex;
import org.calrissian.accumulorecipes.commons.support.qfd.QfdHelper;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.commons.transform.KeyToTupleCollectionQueryXform;
import org.calrissian.accumulorecipes.commons.transform.KeyToTupleCollectionWholeColFXform;
import org.calrissian.mango.domain.entity.BaseEntity;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.types.TypeRegistry;

public class EntityQfdHelper
extends QfdHelper<Entity> {
    public EntityQfdHelper(Connector connector, String indexTable, String shardTable, StoreConfig config, ShardBuilder<Entity> shardBuilder, TypeRegistry<String> typeRegistry, KeyValueIndex<Entity> keyValueIndex) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, indexTable, shardTable, config, shardBuilder, typeRegistry, keyValueIndex);
    }

    protected String buildId(Entity item) {
        return item.getType() + "\u0001" + item.getId();
    }

    protected Value buildValue(Entity item) {
        return Constants.EMPTY_VALUE;
    }

    protected long buildTimestamp(Entity item) {
        return System.currentTimeMillis();
    }

    public QueryXform buildQueryXform(Set<String> selectFields) {
        return new QueryXform(EntityQfdHelper.getKryo(), (TypeRegistry<String>)this.getTypeRegistry(), selectFields, this.getMetadataSerDe());
    }

    public WholeColFXform buildWholeColFXform(Set<String> selectFields) {
        return new WholeColFXform(EntityQfdHelper.getKryo(), (TypeRegistry<String>)this.getTypeRegistry(), selectFields, this.getMetadataSerDe());
    }

    protected void configureIndexTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    protected void configureShardTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    public static class WholeColFXform
    extends KeyToTupleCollectionWholeColFXform<Entity> {
        public WholeColFXform(Kryo kryo, TypeRegistry<String> typeRegistry, Set<String> selectFields, MetadataSerDe metadataSerDe) {
            super(kryo, typeRegistry, selectFields, metadataSerDe);
        }

        protected Entity buildEntryFromKey(Key k) {
            String[] typeId = StringUtils.splitPreserveAllTokens((String)k.getColumnFamily().toString(), (String)"\u0001");
            return new BaseEntity(typeId[0], typeId[1]);
        }
    }

    public static class QueryXform
    extends KeyToTupleCollectionQueryXform<Entity> {
        public QueryXform(Kryo kryo, TypeRegistry<String> typeRegistry, Set<String> selectFields, MetadataSerDe metadataSerDe) {
            super(kryo, typeRegistry, selectFields, metadataSerDe);
        }

        protected Entity buildTupleCollectionFromKey(Key k) {
            String[] typeId = StringUtils.splitPreserveAllTokens((String)k.getColumnFamily().toString(), (String)"\u0001");
            return new BaseEntity(typeId[0], typeId[1]);
        }
    }
}

