/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.mango.domain.entity.Entity;

public class EntityShardBuilder
implements ShardBuilder<Entity> {
    private int partitionSize;

    public EntityShardBuilder(int partitionSize) {
        this.partitionSize = partitionSize;
    }

    public String buildShard(String entityType, String entityId) {
        int partition = Math.abs(entityId.hashCode() % this.partitionSize);
        return this.buildShard(entityType, partition);
    }

    public String buildShard(String entityType, int partition) {
        return String.format("%s_%" + Integer.toString(this.partitionSize).length() + "d", entityType, partition);
    }

    public Set<Text> buildShardsForTypes(Collection<String> types) {
        HashSet<Text> ret = new HashSet<Text>();
        for (int i = 0; i < this.partitionSize; ++i) {
            for (String type : types) {
                ret.add(new Text(this.buildShard(type, i)));
            }
        }
        return ret;
    }

    public String buildShard(Entity item) {
        return this.buildShard(item.getType(), item.getId());
    }
}

