/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.calrissian.accumulorecipes.commons.hadoop.BaseQfdInputFormat;
import org.calrissian.accumulorecipes.commons.iterators.WholeColumnFamilyIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.metadata.SimpleMetadataSerDe;
import org.calrissian.accumulorecipes.entitystore.impl.AccumuloEntityStore;
import org.calrissian.accumulorecipes.entitystore.model.EntityWritable;
import org.calrissian.accumulorecipes.entitystore.support.EntityGlobalIndexVisitor;
import org.calrissian.accumulorecipes.entitystore.support.EntityQfdHelper;
import org.calrissian.accumulorecipes.entitystore.support.EntityShardBuilder;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.io.Serializables;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class EntityInputFormat
extends BaseQfdInputFormat<Entity, EntityWritable> {
    private static final String QUERY = "query";
    private static final String TYPE_REGISTRY = "typeRegistry";

    public static void setInputInfo(Job job, String username, byte[] password, Authorizations auths) throws AccumuloSecurityException {
        EntityInputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken(password));
        EntityInputFormat.setInputTableName((Job)job, (String)"entity_shard");
        EntityInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
    }

    public static void setQueryInfo(Job job, Set<String> entityTypes, Node query) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EntityInputFormat.setQueryInfo(job, entityTypes, query, AccumuloEntityStore.DEFAULT_SHARD_BUILDER, (TypeRegistry<String>)LexiTypeEncoders.LEXI_TYPES);
    }

    public static void setQueryInfo(Job job, Set<String> entityTypes, Node query, EntityShardBuilder shardBuilder, TypeRegistry<String> typeRegistry) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EntityInputFormat.validateOptions((JobContext)job);
        Instance instance = EntityInputFormat.getInstance((JobContext)job);
        Connector connector = instance.getConnector(EntityInputFormat.getPrincipal((JobContext)job), EntityInputFormat.getAuthenticationToken((JobContext)job));
        BatchScanner scanner = connector.createBatchScanner("entity_index", EntityInputFormat.getScanAuthorizations((JobContext)job), 5);
        EntityGlobalIndexVisitor globalIndexVisitor = new EntityGlobalIndexVisitor(scanner, shardBuilder, entityTypes);
        EntityInputFormat.configureScanner((Job)job, (Node)query, (GlobalIndexVisitor)globalIndexVisitor, typeRegistry);
        job.getConfiguration().setBoolean(QUERY, true);
        job.getConfiguration().set(TYPE_REGISTRY, new String(Serializables.toBase64(typeRegistry)));
    }

    public static void setMetadataSerDe(Configuration configuration, MetadataSerDe metadataSerDe) throws IOException {
        configuration.set("metadataSerDe", new String(Serializables.toBase64((Serializable)metadataSerDe)));
    }

    public static void setQueryInfo(Job job, Set<String> entityTypes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EntityInputFormat.setQueryInfo(job, entityTypes, AccumuloEntityStore.DEFAULT_SHARD_BUILDER, (TypeRegistry<String>)LexiTypeEncoders.LEXI_TYPES);
    }

    public static void setQueryInfo(Job job, Set<String> entityTypes, EntityShardBuilder shardBuilder, TypeRegistry<String> typeRegistry) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EntityInputFormat.validateOptions((JobContext)job);
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (String type : entityTypes) {
            Set<Text> shards = shardBuilder.buildShardsForTypes(Collections.singleton(type));
            for (Text shard : shards) {
                ranges.add(Range.prefix((CharSequence)shard.toString(), (CharSequence)type));
            }
        }
        EntityInputFormat.setRanges((Job)job, ranges);
        IteratorSetting iteratorSetting = new IteratorSetting(16, "wholeColumnFamilyIterator", WholeColumnFamilyIterator.class);
        EntityInputFormat.addIterator((Job)job, (IteratorSetting)iteratorSetting);
        job.getConfiguration().setBoolean(QUERY, false);
        job.getConfiguration().set(TYPE_REGISTRY, new String(Serializables.toBase64(typeRegistry)));
    }

    public static void setSelectFields(Configuration config, Set<String> selectFields) {
        if (selectFields != null) {
            config.setStrings("selectFields", selectFields.toArray(new String[0]));
        }
    }

    protected Function<Map.Entry<Key, Value>, Entity> getTransform(Configuration configuration) {
        String[] selectFields = configuration.getStrings("selectFields");
        HashSet<String> finalSelectFields = selectFields != null ? new HashSet<String>(Arrays.asList(selectFields)) : null;
        try {
            TypeRegistry typeRegistry = (TypeRegistry)Serializables.fromBase64((byte[])configuration.get(TYPE_REGISTRY).getBytes());
            Object metadataSerDe = configuration.get("metadataSerDe") != null ? (MetadataSerDe)Serializables.fromBase64((byte[])configuration.get("metadataSerDe").getBytes()) : new SimpleMetadataSerDe(typeRegistry);
            Kryo kryo = new Kryo();
            EventFields.initializeKryo((Kryo)kryo);
            if (configuration.getBoolean(QUERY, false)) {
                return new EntityQfdHelper.QueryXform(kryo, (TypeRegistry<String>)typeRegistry, finalSelectFields, (MetadataSerDe)metadataSerDe);
            }
            return new EntityQfdHelper.WholeColFXform(kryo, (TypeRegistry<String>)typeRegistry, finalSelectFields, (MetadataSerDe)metadataSerDe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected EntityWritable getWritable() {
        return new EntityWritable();
    }
}

