/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.model;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.calrissian.accumulorecipes.commons.domain.Gettable;
import org.calrissian.accumulorecipes.commons.domain.Settable;
import org.calrissian.accumulorecipes.commons.hadoop.TupleWritable;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.entity.BaseEntity;
import org.calrissian.mango.domain.entity.Entity;

public class EntityWritable
implements WritableComparable,
Settable<Entity>,
Gettable<Entity> {
    private TupleWritable tupleWritable = new TupleWritable();
    private Entity entity;

    public EntityWritable() {
    }

    public EntityWritable(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
    }

    public void setTupleWritable(TupleWritable sharedTupleWritable) {
        this.tupleWritable = sharedTupleWritable;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.entity.getType());
        dataOutput.writeUTF(this.entity.getId());
        dataOutput.writeInt(this.entity.getTuples() != null ? this.entity.getTuples().size() : 0);
        for (Tuple tuple : this.entity.getTuples()) {
            this.tupleWritable.set(tuple);
            this.tupleWritable.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        String entityType = dataInput.readUTF();
        String id = dataInput.readUTF();
        this.entity = new BaseEntity(entityType, id);
        int tupleSize = dataInput.readInt();
        for (int i = 0; i < tupleSize; ++i) {
            this.tupleWritable.readFields(dataInput);
            this.entity.put(this.tupleWritable.get());
        }
    }

    public void set(Entity entity) {
        this.entity = entity;
    }

    public Entity get() {
        return this.entity;
    }

    public int compareTo(Object o) {
        Entity entity2 = (Entity)o;
        int res = this.entity.getType().compareTo(entity2.getType());
        if (res == 0) {
            res = this.entity.getId().compareTo(entity2.getId());
        }
        return res;
    }
}

