/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.entitystore.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.calrissian.accumulorecipes.commons.support.criteria.CardinalityKey;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.qfd.GlobalIndexValue;
import org.calrissian.accumulorecipes.entitystore.support.EntityCardinalityKey;
import org.calrissian.accumulorecipes.entitystore.support.EntityShardBuilder;
import org.calrissian.mango.criteria.domain.AbstractKeyValueLeaf;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class EntityGlobalIndexVisitor
implements GlobalIndexVisitor {
    private static TypeRegistry<String> registry = LexiTypeEncoders.LEXI_TYPES;
    private BatchScanner indexScanner;
    private EntityShardBuilder shardBuilder;
    private Set<String> shards = new HashSet<String>();
    private Map<CardinalityKey, Long> cardinalities = new HashMap<CardinalityKey, Long>();
    private Set<String> types;
    private Set<Leaf> leaves = new HashSet<Leaf>();

    public EntityGlobalIndexVisitor(BatchScanner indexScanner, EntityShardBuilder shardBuilder, Set<String> types) {
        this.indexScanner = indexScanner;
        this.shardBuilder = shardBuilder;
        this.types = types;
    }

    public Map<CardinalityKey, Long> getCardinalities() {
        return this.cardinalities;
    }

    public Set<String> getShards() {
        return this.shards;
    }

    public void begin(ParentNode parentNode) {
    }

    public void end(ParentNode parentNode) {
    }

    public void exec() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Leaf leaf : this.leaves) {
            AbstractKeyValueLeaf kvLeaf = (AbstractKeyValueLeaf)leaf;
            String alias = registry.getAlias(kvLeaf.getValue());
            for (String type : this.types) {
                if (NodeUtils.isRangeLeaf((Leaf)leaf) || leaf instanceof HasLeaf || leaf instanceof HasNotLeaf) {
                    if (alias != null) {
                        ranges.add(Range.prefix((CharSequence)(type + "_" + "k" + "_" + kvLeaf.getKey()), (CharSequence)alias));
                        continue;
                    }
                    ranges.add(Range.prefix((CharSequence)(type + "_" + "k" + "_" + kvLeaf.getKey())));
                    continue;
                }
                String normVal = (String)registry.encode(kvLeaf.getValue());
                ranges.add(Range.prefix((CharSequence)(type + "_" + "v" + "_" + alias + "__" + normVal), (CharSequence)kvLeaf.getKey()));
            }
        }
        this.indexScanner.setRanges(ranges);
        for (Map.Entry entry : this.indexScanner) {
            EntityCardinalityKey key = new EntityCardinalityKey((Key)entry.getKey());
            Long cardinality = this.cardinalities.get((Object)key);
            if (cardinality == null) {
                cardinality = 0L;
            }
            long newCardinality = new GlobalIndexValue((Value)entry.getValue()).getCardinatlity();
            this.cardinalities.put((CardinalityKey)key, cardinality + newCardinality);
            this.shards.add(((Key)entry.getKey()).getColumnQualifier().toString());
        }
        this.indexScanner.close();
    }

    public void visit(Leaf leaf) {
        this.leaves.add(leaf);
    }
}

