/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.cli;

import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.eventstore.support.ShardBuilder;
import org.joda.time.DateTime;

public class ShardSplitter {
    public static void main(String[] args) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (args.length != 7) {
            System.out.println("Usage: " + ShardSplitter.class.getName() + "<zookeepers> <instance> <username> <password> <tableName> <start day: yyyy-mm-dd> <stop day: yyyy-mm-dd>");
            System.exit(1);
        }
        String zookeepers = args[0];
        String instance = args[1];
        String username = args[2];
        String password = args[3];
        String tableName = args[4];
        DateTime start = DateTime.parse((String)args[5]);
        DateTime stop = DateTime.parse((String)args[6]);
        ZooKeeperInstance accInst = new ZooKeeperInstance(instance, zookeepers);
        Connector connector = accInst.getConnector(username, password.getBytes());
        SortedSet<Text> shards = new ShardBuilder(7).buildShardsInRange(start.toDate(), stop.toDate());
        connector.tableOperations().addSplits(tableName, shards);
    }
}

