/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.impl;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.accumulorecipes.eventstore.EventStore;
import org.calrissian.accumulorecipes.eventstore.iterator.EventIterator;
import org.calrissian.accumulorecipes.eventstore.support.QueryNodeHelper;
import org.calrissian.accumulorecipes.eventstore.support.ShardBuilder;
import org.calrissian.accumulorecipes.eventstore.support.query.QueryResultsVisitor;
import org.calrissian.mango.accumulo.types.AccumuloTypeEncoders;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.TypeRegistry;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

public class AccumuloEventStore
implements EventStore {
    private static final String DEFAULT_IDX_TABLE_NAME = "eventStore_index";
    private static final String DEFAULT_SHARD_TABLE_NAME = "eventStore_shard";
    private static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(3, 100000L, 10000L, 3);
    private static final ShardBuilder shard = new ShardBuilder(7);
    private final Connector connector;
    private final String indexTable;
    private final String shardTable;
    private final MultiTableBatchWriter multiTableWriter;
    private final TypeRegistry<String> typeRegistry;
    private final QueryNodeHelper queryHelper;

    public AccumuloEventStore(Connector connector) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this(connector, DEFAULT_IDX_TABLE_NAME, DEFAULT_SHARD_TABLE_NAME, new StoreConfig());
    }

    public AccumuloEventStore(Connector connector, String indexTable, String shardTable, StoreConfig config) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)indexTable);
        Preconditions.checkNotNull((Object)shardTable);
        Preconditions.checkNotNull((Object)config);
        this.connector = connector;
        this.indexTable = indexTable;
        this.shardTable = shardTable;
        this.typeRegistry = AccumuloTypeEncoders.ACCUMULO_TYPES;
        if (!connector.tableOperations().exists(this.indexTable)) {
            connector.tableOperations().create(this.indexTable);
            this.configureIndexTable(connector, this.indexTable);
        }
        if (!connector.tableOperations().exists(this.shardTable)) {
            connector.tableOperations().create(this.shardTable);
            this.configureShardTable(connector, this.indexTable);
        }
        this.queryHelper = new QueryNodeHelper(connector, this.shardTable, config.getMaxQueryThreads(), shard, this.typeRegistry);
        this.multiTableWriter = connector.createMultiTableBatchWriter(config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    protected void configureIndexTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    protected void configureShardTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    public void shutdown() throws MutationsRejectedException {
        this.multiTableWriter.close();
    }

    @Override
    public void save(Iterable<StoreEntry> events) {
        Preconditions.checkNotNull(events);
        try {
            for (StoreEntry event : events) {
                if (event.getTuples() == null || event.getTuples().isEmpty()) continue;
                String shardId = shard.buildShard(event.getTimestamp(), event.getId());
                Mutation indexMutation = new Mutation((CharSequence)event.getId());
                indexMutation.put(new Text(shardId), new Text(""), event.getTimestamp(), new Value("".getBytes()));
                Mutation shardMutation = new Mutation((CharSequence)shardId);
                for (Tuple tuple : event.getTuples()) {
                    shardMutation.put(new Text("f\u0000" + event.getId()), new Text(tuple.getKey() + "\u0000" + this.typeRegistry.getAlias(tuple.getValue()) + "\u0000" + (String)this.typeRegistry.encode(tuple.getValue())), new ColumnVisibility(tuple.getVisibility()), event.getTimestamp(), new Value("".getBytes()));
                    shardMutation.put(new Text("b\u0000" + tuple.getKey() + "\u0000" + this.typeRegistry.getAlias(tuple.getValue()) + "\u0000" + (String)this.typeRegistry.encode(tuple.getValue())), new Text(event.getId()), new ColumnVisibility(tuple.getVisibility()), event.getTimestamp(), new Value("".getBytes()));
                    shardMutation.put(new Text("v\u0000" + this.typeRegistry.getAlias(tuple.getValue()) + "\u0000" + (String)this.typeRegistry.encode(tuple.getValue())), new Text(tuple.getKey() + "\u0000" + event.getId()), new ColumnVisibility(tuple.getVisibility()), event.getTimestamp(), new Value("".getBytes()));
                }
                this.multiTableWriter.getBatchWriter(this.indexTable).addMutation(indexMutation);
                this.multiTableWriter.getBatchWriter(this.shardTable).addMutation(shardMutation);
            }
            this.multiTableWriter.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterable<StoreEntry> query(Date start, Date end, Node node, Auths auths) {
        return new QueryResultsVisitor(node, this.queryHelper, start, end, auths.getAuths()).getResults();
    }

    @Override
    public StoreEntry get(String uuid, Auths auths) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)auths);
        try {
            Scanner scanner = this.connector.createScanner(this.indexTable, auths.getAuths());
            scanner.setRange(new Range((CharSequence)uuid, (CharSequence)(uuid + "\uffff")));
            Iterator itr = scanner.iterator();
            if (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                String shardId = ((Key)entry.getKey()).getColumnFamily().toString();
                Scanner eventScanner = this.connector.createScanner(this.shardTable, auths.getAuths());
                eventScanner.setRange(new Range((CharSequence)shardId));
                eventScanner.fetchColumnFamily(new Text("f\u0000" + uuid));
                IteratorSetting iteratorSetting = new IteratorSetting(16, "eventIterator", EventIterator.class);
                eventScanner.addScanIterator(iteratorSetting);
                itr = eventScanner.iterator();
                if (itr.hasNext()) {
                    Map.Entry event = (Map.Entry)itr.next();
                    return (StoreEntry)new ObjectMapper().withModule((Module)new TupleModule(this.typeRegistry)).readValue(new String(((Value)event.getValue()).get()), StoreEntry.class);
                }
            }
            return null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

