/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.iterator;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.calrissian.accumulorecipes.eventstore.iterator.IteratorUtils;
import org.calrissian.mango.accumulo.types.AccumuloTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class EventIntersectingIterator
extends IntersectingIterator {
    private TypeRegistry<String> typeRegistry;
    protected SortedKeyValueIterator<Key, Value> sourceItr;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.sourceItr = source.deepCopy(env);
        this.typeRegistry = AccumuloTypeEncoders.ACCUMULO_TYPES;
    }

    public Value getTopValue() {
        if (this.hasTop()) {
            Key topKey = this.getTopKey();
            String eventUUID = topKey.getColumnQualifier().toString();
            return IteratorUtils.retrieveFullEvent(eventUUID, topKey, this.sourceItr, this.typeRegistry);
        }
        return new Value("".getBytes());
    }
}

