/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.iterator;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.TypeRegistry;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

public class IteratorUtils {
    public static Value retrieveFullEvent(String eventUUID, Key topKey, SortedKeyValueIterator<Key, Value> sourceItr, TypeRegistry<String> typeRegistry) {
        Key key = topKey;
        Key startRangeKey = new Key(key.getRow(), new Text("f\u0000" + eventUUID));
        Key stopRangeKey = new Key(key.getRow(), new Text("f\u0000" + eventUUID + "\uffff"));
        Range eventRange = new Range(startRangeKey, stopRangeKey);
        long timestamp = 0L;
        try {
            sourceItr.seek(eventRange, Collections.emptyList(), false);
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            while (sourceItr.hasTop()) {
                Key nextKey = (Key)sourceItr.getTopKey();
                sourceItr.next();
                if (!nextKey.getColumnFamily().toString().endsWith(eventUUID)) break;
                String[] keyValueDatatype = nextKey.getColumnQualifier().toString().split("\u0000");
                if (keyValueDatatype.length != 3) continue;
                tuples.add(new Tuple(keyValueDatatype[0], typeRegistry.decode(keyValueDatatype[1], (Object)keyValueDatatype[2]), nextKey.getColumnVisibility().toString()));
                timestamp = nextKey.getTimestamp();
            }
            StoreEntry event = new StoreEntry(eventUUID, timestamp);
            if (tuples.size() > 0) {
                event.putAll(tuples);
            }
            return new Value(new ObjectMapper().withModule((Module)new TupleModule(typeRegistry)).writeValueAsBytes((Object)event));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

