/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import org.apache.hadoop.io.Text;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class AndNodeColumns {
    protected final Text[] columns;
    protected final boolean[] notFlags;

    private static Text generateColumn(String key, Object value, TypeRegistry<String> typeRegistry) {
        try {
            return new Text("b\u0000" + key + "\u0000" + typeRegistry.getAlias(value) + "\u0000" + (String)typeRegistry.encode(value));
        }
        catch (TypeEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public AndNodeColumns(AndNode query, TypeRegistry<String> typeRegistry) {
        this.columns = new Text[query.children().size()];
        this.notFlags = new boolean[this.columns.length];
        int i = 0;
        for (Node node : query.children()) {
            EqualsLeaf leaf;
            if (node instanceof NotEqualsLeaf) {
                this.notFlags[i] = true;
                leaf = (NotEqualsLeaf)node;
                this.columns[i] = AndNodeColumns.generateColumn(leaf.getKey(), leaf.getValue(), typeRegistry);
            } else if (node instanceof EqualsLeaf) {
                leaf = (EqualsLeaf)node;
                this.columns[i] = AndNodeColumns.generateColumn(leaf.getKey(), leaf.getValue(), typeRegistry);
            }
            ++i;
        }
    }

    public Text[] getColumns() {
        return this.columns;
    }

    public boolean[] getNotFlags() {
        return this.notFlags;
    }
}

