/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.accumulorecipes.commons.iterators.TimeLimitingFilter;
import org.calrissian.accumulorecipes.eventstore.iterator.EventIntersectingIterator;
import org.calrissian.accumulorecipes.eventstore.iterator.EventIterator;
import org.calrissian.accumulorecipes.eventstore.support.AndNodeColumns;
import org.calrissian.accumulorecipes.eventstore.support.ShardBuilder;
import org.calrissian.accumulorecipes.eventstore.support.query.validators.AndSingleDepthOnlyValidator;
import org.calrissian.mango.accumulo.Scanners;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.visitor.NodeVisitor;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.TypeRegistry;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

public class QueryNodeHelper {
    private final TypeRegistry<String> typeRegistry;
    private final ObjectMapper objectMapper;
    private Function<Map.Entry<Key, Value>, StoreEntry> entityTransform = new Function<Map.Entry<Key, Value>, StoreEntry>(){

        public StoreEntry apply(Map.Entry<Key, Value> entry) {
            try {
                return (StoreEntry)QueryNodeHelper.this.objectMapper.readValue(entry.getValue().get(), StoreEntry.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    protected final Connector connector;
    protected final String shardTable;
    protected final Integer numThreads;
    protected final ShardBuilder shard;

    public QueryNodeHelper(Connector connector, String shardTable, int numThreads, ShardBuilder shard, TypeRegistry<String> typeRegistry) {
        this.connector = connector;
        this.shardTable = shardTable;
        this.numThreads = numThreads;
        this.shard = shard;
        this.typeRegistry = typeRegistry;
        this.objectMapper = new ObjectMapper().withModule((Module)new TupleModule(typeRegistry));
    }

    public CloseableIterable<StoreEntry> queryAndNode(Date start, Date stop, AndNode query, Authorizations auths) throws Exception {
        BatchScanner scanner = this.connector.createBatchScanner(this.shardTable, auths, this.numThreads.intValue());
        String[] range = this.shard.getRange(start, stop);
        IteratorSetting setting = new IteratorSetting(15, "timeLimit", TimeLimitingFilter.class);
        TimeLimitingFilter.setCurrentTime((IteratorSetting)setting, (Long)stop.getTime());
        TimeLimitingFilter.setTTL((IteratorSetting)setting, (Long)(stop.getTime() - start.getTime()));
        scanner.addScanIterator(setting);
        if (query == null || query.children() == null || query.children().size() <= 1) {
            throw new IllegalArgumentException("You must have 2 or more items to query.");
        }
        query.accept((NodeVisitor)new AndSingleDepthOnlyValidator());
        AndNodeColumns andNodeColumns = new AndNodeColumns(query, this.typeRegistry);
        IteratorSetting is = new IteratorSetting(16, "eventIntersectingIterator", EventIntersectingIterator.class);
        EventIntersectingIterator.setColumnFamilies((IteratorSetting)is, (Text[])andNodeColumns.getColumns(), (boolean[])andNodeColumns.getNotFlags());
        scanner.addScanIterator(is);
        scanner.setRanges(Collections.singleton(new Range((CharSequence)range[0], (CharSequence)(range[1] + "\uffff"))));
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), this.entityTransform);
    }

    public CloseableIterable<StoreEntry> querySingleLeaf(Date start, Date stop, Leaf query, Authorizations auths) throws Exception {
        BatchScanner scanner = this.connector.createBatchScanner(this.shardTable, auths, this.numThreads.intValue());
        String[] range = this.shard.getRange(start, stop);
        IteratorSetting setting = new IteratorSetting(15, "timeLimit", TimeLimitingFilter.class);
        TimeLimitingFilter.setCurrentTime((IteratorSetting)setting, (Long)stop.getTime());
        TimeLimitingFilter.setTTL((IteratorSetting)setting, (Long)(stop.getTime() - start.getTime()));
        scanner.addScanIterator(setting);
        if (query != null) {
            if (!(query instanceof EqualsLeaf)) {
                throw new IllegalArgumentException("The query " + query + " was not supported");
            }
        } else {
            throw new RuntimeException("Need to have a query and/or leaves of the query");
        }
        EqualsLeaf equalsLeaf = (EqualsLeaf)query;
        IteratorSetting iteratorSetting = new IteratorSetting(16, "eventIterator", EventIterator.class);
        scanner.addScanIterator(iteratorSetting);
        scanner.fetchColumnFamily(new Text("b\u0000" + equalsLeaf.getKey() + "\u0000" + this.typeRegistry.getAlias(equalsLeaf.getValue()) + "\u0000" + (String)this.typeRegistry.encode(equalsLeaf.getValue())));
        scanner.setRanges(Collections.singleton(new Range((CharSequence)range[0], (CharSequence)(range[1] + "\uffff"))));
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), this.entityTransform);
    }
}

