/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.io.Text;

public class ShardBuilder {
    protected final Integer numPartitions;
    protected String delimiter = "_";
    protected String dateFormat = "yyyyMMddHH";

    public ShardBuilder(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public String buildShard(long timestamp, String uuid) {
        return this.buildShard(timestamp, Math.abs(uuid.hashCode()) % this.numPartitions);
    }

    public String buildShard(long timestamp, int partition) {
        int partitionWidth = String.valueOf(this.numPartitions).length();
        Date date = new Date(timestamp);
        return String.format("%s%s%0" + partitionWidth + "d", new SimpleDateFormat(this.dateFormat).format(date), this.delimiter, partition);
    }

    public SortedSet<Text> buildShardsInRange(Date start, Date stop) {
        TreeSet<Text> shards = new TreeSet<Text>();
        int hours = (int)((stop.getTime() - start.getTime()) / 3600000L);
        hours = hours > 0 ? hours : 1;
        for (int i = 0; i < hours; ++i) {
            for (int j = 0; j < this.numPartitions; ++j) {
                shards.add(new Text(this.buildShard(start.getTime(), j)));
            }
            start.setTime(start.getTime() + 3600000L);
        }
        return shards;
    }

    public String[] getRange(Date start, Date end) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        return new String[]{sdf.format(start), sdf.format(end)};
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

