/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import org.apache.accumulo.core.security.Authorizations;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.accumulorecipes.eventstore.support.QueryNodeHelper;
import org.calrissian.accumulorecipes.eventstore.support.query.validators.MultipleEqualsValidator;
import org.calrissian.accumulorecipes.eventstore.support.query.validators.NoAndOrValidator;
import org.calrissian.accumulorecipes.eventstore.support.query.validators.NoOrNotEqualsValidator;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.utils.NodeUtils;
import org.calrissian.mango.criteria.visitor.CollapseParentClauseVisitor;
import org.calrissian.mango.criteria.visitor.EmptyParentCollapseVisitor;
import org.calrissian.mango.criteria.visitor.NodeVisitor;
import org.calrissian.mango.criteria.visitor.SingleClauseCollapseVisitor;

public class QueryResultsVisitor
implements NodeVisitor {
    protected Date start;
    protected Date end;
    protected Authorizations auths;
    protected CloseableIterable<StoreEntry> iterable = null;
    private QueryNodeHelper queryHelper;

    public QueryResultsVisitor(Node query, QueryNodeHelper queryHelper, Date start, Date end, Authorizations auths) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)queryHelper);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)auths);
        this.queryHelper = queryHelper;
        this.start = start;
        this.end = end;
        this.auths = auths;
        this.init(query);
    }

    protected void init(Node query) {
        query.accept((NodeVisitor)new SingleClauseCollapseVisitor());
        query.accept((NodeVisitor)new EmptyParentCollapseVisitor());
        query.accept((NodeVisitor)new CollapseParentClauseVisitor());
        query.accept((NodeVisitor)new NoAndOrValidator());
        query.accept((NodeVisitor)new NoOrNotEqualsValidator());
        query.accept((NodeVisitor)new MultipleEqualsValidator());
        query.accept((NodeVisitor)this);
    }

    public void begin(ParentNode node) {
    }

    public void end(ParentNode node) {
        try {
            if (NodeUtils.parentContainsOnlyLeaves((ParentNode)node)) {
                Node child;
                ParentNode n = node;
                if (node instanceof AndNode && node.children() != null && node.children().size() == 1 && NodeUtils.isLeaf((Node)(child = (Node)node.children().get(0)))) {
                    n = child;
                }
                this.populateIterable((Node)n);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void populateIterable(Node node) throws IOException {
        if (node instanceof AndNode) {
            CloseableIterable<StoreEntry> query = this.andResults((AndNode)node);
            this.iterable = this.iterable != null ? CloseableIterables.chain((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{query, this.iterable})) : query;
        } else if (node instanceof OrNode) {
            for (Node child : node.children()) {
                this.populateIterable(child);
            }
        } else if (node instanceof Leaf) {
            CloseableIterable<StoreEntry> query = this.leafResults((Leaf)node);
            this.iterable = this.iterable != null ? CloseableIterables.chain((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{query, this.iterable})) : query;
        }
    }

    public void visit(Leaf node) {
    }

    public CloseableIterable<StoreEntry> getResults() {
        return this.iterable;
    }

    protected CloseableIterable<StoreEntry> andResults(AndNode andNode) throws IOException {
        try {
            return this.queryHelper.queryAndNode(this.start, this.end, andNode, this.auths);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected CloseableIterable<StoreEntry> leafResults(Leaf node) throws IOException {
        try {
            return this.queryHelper.querySingleLeaf(this.start, this.end, node, this.auths);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

