/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support.query.validators;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.utils.NodeUtils;
import org.calrissian.mango.criteria.visitor.NodeVisitor;

public class AndSingleDepthOnlyValidator
implements NodeVisitor {
    public void begin(ParentNode node) {
        if (!(node instanceof AndNode)) {
            throw new IllegalArgumentException("Not an And Node");
        }
        int size = node.getNodes().size();
        if (node.getNodes() == null || size < 2) {
            throw new IllegalArgumentException("At least 2 query leaves expected");
        }
        if (!NodeUtils.parentContainsOnlyLeaves((ParentNode)node)) {
            throw new IllegalArgumentException("Only Leaf nodes expected. Not a single depth node");
        }
        Collection notEqNodes = Collections2.filter((Collection)node.getNodes(), (Predicate)new Predicate<Node>(){

            public boolean apply(Node node) {
                return node instanceof NotEqualsLeaf;
            }
        });
        if (notEqNodes != null && notEqNodes.size() == size) {
            throw new IllegalArgumentException("Not every leaf can be a not equals");
        }
    }

    public void end(ParentNode node) {
    }

    public void visit(Leaf node) {
    }
}

