/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.calrissian.accumulorecipes.commons.hadoop.BaseQfdInputFormat;
import org.calrissian.accumulorecipes.commons.hadoop.EventWritable;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.metadata.SimpleMetadataSerDe;
import org.calrissian.accumulorecipes.eventstore.impl.AccumuloEventStore;
import org.calrissian.accumulorecipes.eventstore.support.EventGlobalIndexVisitor;
import org.calrissian.accumulorecipes.eventstore.support.EventQfdHelper;
import org.calrissian.accumulorecipes.eventstore.support.shard.EventShardBuilder;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.io.Serializables;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class EventInputFormat
extends BaseQfdInputFormat<Event, EventWritable> {
    public static void setInputInfo(Configuration config, String username, byte[] password, Authorizations auths) {
        EventInputFormat.setInputInfo((Configuration)config, (String)username, (byte[])password, (String)"eventStore_shard", (Authorizations)auths);
    }

    public static void setQueryInfo(Configuration config, Date start, Date end, Node query) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EventInputFormat.setQueryInfo(config, start, end, query, AccumuloEventStore.DEFAULT_SHARD_BUILDER, (TypeRegistry<String>)LexiTypeEncoders.LEXI_TYPES);
    }

    public static void setQueryInfo(Configuration config, Date start, Date end, Node query, EventShardBuilder shardBuilder, TypeRegistry<String> typeRegistry) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        EventInputFormat.validateOptions((Configuration)config);
        Instance instance = EventInputFormat.getInstance((Configuration)config);
        Connector connector = instance.getConnector(EventInputFormat.getUsername((Configuration)config), EventInputFormat.getPassword((Configuration)config));
        BatchScanner scanner = connector.createBatchScanner("eventStore_index", EventInputFormat.getAuthorizations((Configuration)config), 5);
        EventGlobalIndexVisitor globalIndexVisitor = new EventGlobalIndexVisitor(start, end, scanner, shardBuilder);
        config.set("typeRegistry", new String(Serializables.toBase64(typeRegistry)));
        EventInputFormat.configureScanner((Configuration)config, (Node)query, (GlobalIndexVisitor)globalIndexVisitor, typeRegistry);
    }

    public static void setMetadataSerDe(Configuration configuration, MetadataSerDe metadataSerDe) throws IOException {
        configuration.set("metadataSerDe", new String(Serializables.toBase64((Serializable)metadataSerDe)));
    }

    public static void setSelectFields(Configuration config, Set<String> selectFields) {
        if (selectFields != null) {
            config.setStrings("selectFields", selectFields.toArray(new String[0]));
        }
    }

    protected Function<Map.Entry<Key, Value>, Event> getTransform(Configuration configuration) {
        try {
            String[] selectFields = configuration.getStrings("selectFields");
            TypeRegistry typeRegistry = (TypeRegistry)Serializables.fromBase64((byte[])configuration.get("typeRegistry").getBytes());
            Object metadataSerDe = configuration.get("metadataSerDe") != null ? (MetadataSerDe)Serializables.fromBase64((byte[])configuration.get("metadataSerDe").getBytes()) : new SimpleMetadataSerDe(typeRegistry);
            Kryo kryo = new Kryo();
            EventFields.initializeKryo((Kryo)kryo);
            return new EventQfdHelper.QueryXform(kryo, (TypeRegistry<String>)typeRegistry, (Set<String>)(selectFields != null ? new HashSet<String>(Arrays.asList(selectFields)) : null), (MetadataSerDe)metadataSerDe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected EventWritable getWritable() {
        return new EventWritable();
    }
}

