/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.calrissian.accumulorecipes.commons.support.criteria.CardinalityKey;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.accumulorecipes.commons.support.qfd.GlobalIndexValue;
import org.calrissian.accumulorecipes.eventstore.support.EventCardinalityKey;
import org.calrissian.accumulorecipes.eventstore.support.shard.EventShardBuilder;
import org.calrissian.mango.criteria.domain.AbstractKeyValueLeaf;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class EventGlobalIndexVisitor
implements GlobalIndexVisitor {
    private static TypeRegistry<String> registry = LexiTypeEncoders.LEXI_TYPES;
    private Date start;
    private Date end;
    private BatchScanner indexScanner;
    private EventShardBuilder shardBuilder;
    private Set<String> shards = new HashSet<String>();
    private Map<CardinalityKey, Long> cardinalities = new HashMap<CardinalityKey, Long>();
    private Set<Leaf> leaves = new HashSet<Leaf>();

    public EventGlobalIndexVisitor(Date start, Date end, BatchScanner indexScanner, EventShardBuilder shardBuilder) {
        this.start = start;
        this.end = end;
        this.indexScanner = indexScanner;
        this.shardBuilder = shardBuilder;
    }

    public Map<CardinalityKey, Long> getCardinalities() {
        return this.cardinalities;
    }

    public Set<String> getShards() {
        return this.shards;
    }

    public void exec() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Leaf leaf : this.leaves) {
            AbstractKeyValueLeaf kvLeaf = (AbstractKeyValueLeaf)leaf;
            String alias = registry.getAlias(kvLeaf.getValue());
            String startShard = this.shardBuilder.buildShard(this.start.getTime(), 0);
            String stopShard = this.shardBuilder.buildShard(this.end.getTime(), 6) + "\uffff";
            if (NodeUtils.isRangeLeaf((Leaf)leaf) || leaf instanceof HasLeaf || leaf instanceof HasNotLeaf) {
                ranges.add(new Range(new Key((CharSequence)("k_" + kvLeaf.getKey()), (CharSequence)alias, (CharSequence)startShard), new Key((CharSequence)("k_" + kvLeaf.getKey()), (CharSequence)alias, (CharSequence)stopShard)));
                continue;
            }
            String normVal = (String)registry.encode(kvLeaf.getValue());
            ranges.add(new Range(new Key((CharSequence)("v_" + alias + "__" + normVal), (CharSequence)kvLeaf.getKey(), (CharSequence)startShard), new Key((CharSequence)("v_" + alias + "__" + normVal), (CharSequence)kvLeaf.getKey(), (CharSequence)stopShard)));
        }
        this.indexScanner.setRanges(ranges);
        for (Map.Entry entry : this.indexScanner) {
            EventCardinalityKey key = new EventCardinalityKey((Key)entry.getKey());
            Long cardinality = this.cardinalities.get((Object)key);
            if (cardinality == null) {
                cardinality = 0L;
            }
            GlobalIndexValue value = new GlobalIndexValue((Value)entry.getValue());
            this.cardinalities.put((CardinalityKey)key, cardinality + value.getCardinatlity());
            this.shards.add(((Key)entry.getKey()).getColumnQualifier().toString());
        }
        this.indexScanner.close();
    }

    public void begin(ParentNode parentNode) {
    }

    public void end(ParentNode parentNode) {
    }

    public void visit(Leaf leaf) {
        this.leaves.add(leaf);
    }
}

