/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import com.esotericsoftware.kryo.Kryo;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.Constants;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.qfd.KeyValueIndex;
import org.calrissian.accumulorecipes.commons.support.qfd.QfdHelper;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.commons.transform.KeyToTupleCollectionQueryXform;
import org.calrissian.accumulorecipes.commons.transform.KeyToTupleCollectionWholeColFXform;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.types.TypeRegistry;

public class EventQfdHelper
extends QfdHelper<Event> {
    public EventQfdHelper(Connector connector, String indexTable, String shardTable, StoreConfig config, ShardBuilder<Event> shardBuilder, TypeRegistry<String> typeRegistry, KeyValueIndex<Event> keyValueIndex) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, indexTable, shardTable, config, shardBuilder, typeRegistry, keyValueIndex);
    }

    protected String buildId(Event item) {
        return item.getId();
    }

    protected Value buildValue(Event item) {
        return Constants.EMPTY_VALUE;
    }

    protected long buildTimestamp(Event item) {
        return item.getTimestamp();
    }

    public QueryXform buildQueryXform(Set<String> selectFields) {
        return new QueryXform(EventQfdHelper.getKryo(), (TypeRegistry<String>)this.getTypeRegistry(), selectFields, this.getMetadataSerDe());
    }

    public WholeColFXForm buildWholeColFXform() {
        return new WholeColFXForm(EventQfdHelper.getKryo(), (TypeRegistry<String>)this.getTypeRegistry(), this.getMetadataSerDe());
    }

    protected void configureIndexTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    protected void configureShardTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    public static class WholeColFXForm
    extends KeyToTupleCollectionWholeColFXform<Event> {
        public WholeColFXForm(Kryo kryo, TypeRegistry<String> typeRegistry, MetadataSerDe metadataSerDe) {
            super(kryo, typeRegistry, null, metadataSerDe);
        }

        protected Event buildEntryFromKey(Key k) {
            return new BaseEvent(k.getColumnFamily().toString(), k.getTimestamp());
        }
    }

    public static class QueryXform
    extends KeyToTupleCollectionQueryXform<Event> {
        public QueryXform(Kryo kryo, TypeRegistry<String> typeRegistry, Set<String> selectFields, MetadataSerDe metadataSerDe) {
            super(kryo, typeRegistry, selectFields, metadataSerDe);
        }

        protected Event buildTupleCollectionFromKey(Key k) {
            return new BaseEvent(k.getColumnFamily().toString(), k.getTimestamp());
        }
    }
}

