/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.iterators.EventFieldsFilteringIterator;
import org.calrissian.accumulorecipes.commons.iterators.TimeLimitingFilter;
import org.calrissian.accumulorecipes.commons.iterators.WholeColumnFamilyIterator;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.eventstore.EventStore;
import org.calrissian.accumulorecipes.eventstore.support.EventGlobalIndexVisitor;
import org.calrissian.accumulorecipes.eventstore.support.EventKeyValueIndex;
import org.calrissian.accumulorecipes.eventstore.support.EventQfdHelper;
import org.calrissian.accumulorecipes.eventstore.support.shard.EventShardBuilder;
import org.calrissian.accumulorecipes.eventstore.support.shard.HourlyShardBuilder;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.domain.event.EventIndex;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class AccumuloEventStore
implements EventStore {
    public static final String DEFAULT_IDX_TABLE_NAME = "eventStore_index";
    public static final String DEFAULT_SHARD_TABLE_NAME = "eventStore_shard";
    public static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(3, 100000L, 10000L, 3);
    public static final EventShardBuilder DEFAULT_SHARD_BUILDER = new HourlyShardBuilder(7);
    private final EventShardBuilder shardBuilder = DEFAULT_SHARD_BUILDER;
    private final EventQfdHelper helper;

    public AccumuloEventStore(Connector connector) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this(connector, DEFAULT_IDX_TABLE_NAME, DEFAULT_SHARD_TABLE_NAME, DEFAULT_STORE_CONFIG, (TypeRegistry<String>)LexiTypeEncoders.LEXI_TYPES);
    }

    public AccumuloEventStore(Connector connector, String indexTable, String shardTable, StoreConfig config, TypeRegistry<String> typeRegistry) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)indexTable);
        Preconditions.checkNotNull((Object)shardTable);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(typeRegistry);
        EventKeyValueIndex keyValueIndex = new EventKeyValueIndex(connector, indexTable, this.shardBuilder, config, typeRegistry);
        this.helper = new EventQfdHelper(connector, indexTable, shardTable, config, this.shardBuilder, typeRegistry, keyValueIndex);
    }

    public void shutdown() throws MutationsRejectedException {
        this.helper.shutdown();
    }

    @Override
    public void save(Iterable<? extends Event> events) {
        this.helper.save(events);
    }

    @Override
    public void flush() throws Exception {
        this.helper.flush();
    }

    @Override
    public CloseableIterable<Event> query(Date start, Date end, Node query, Set<String> selectFields, Auths auths) {
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)auths);
        BatchScanner indexScanner = this.helper.buildIndexScanner(auths.getAuths());
        EventGlobalIndexVisitor globalIndexVisitor = new EventGlobalIndexVisitor(start, end, indexScanner, this.shardBuilder);
        BatchScanner scanner = this.helper.buildShardScanner(auths.getAuths());
        IteratorSetting timeFilter = new IteratorSetting(7, TimeLimitingFilter.class);
        TimeLimitingFilter.setCurrentTime((IteratorSetting)timeFilter, (Long)end.getTime());
        TimeLimitingFilter.setTTL((IteratorSetting)timeFilter, (Long)(end.getTime() - start.getTime()));
        scanner.addScanIterator(timeFilter);
        CloseableIterable events = this.helper.query(scanner, globalIndexVisitor, query, (Function)this.helper.buildQueryXform(selectFields), auths);
        indexScanner.close();
        return events;
    }

    @Override
    public CloseableIterable<Event> get(Collection<EventIndex> uuids, Set<String> selectFields, Auths auths) {
        Preconditions.checkNotNull(uuids);
        Preconditions.checkNotNull((Object)auths);
        try {
            BatchScanner eventScanner = this.helper.buildShardScanner(auths.getAuths());
            LinkedList<Range> eventRanges = new LinkedList<Range>();
            for (EventIndex curIndex : uuids) {
                String shardId = this.shardBuilder.buildShard((TupleStore)new BaseEvent(curIndex.getId(), curIndex.getTimestamp().longValue()));
                eventRanges.add(Range.prefix((CharSequence)shardId, (CharSequence)curIndex.getId()));
            }
            eventScanner.setRanges(eventRanges);
            IteratorSetting iteratorSetting = new IteratorSetting(16, "wholeColumnFamilyIterator", WholeColumnFamilyIterator.class);
            eventScanner.addScanIterator(iteratorSetting);
            if (selectFields != null && selectFields.size() > 0) {
                iteratorSetting = new IteratorSetting(15, EventFieldsFilteringIterator.class);
                EventFieldsFilteringIterator.setSelectFields((IteratorSetting)iteratorSetting, selectFields);
                eventScanner.addScanIterator(iteratorSetting);
            }
            return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)eventScanner), (Function)this.helper.buildWholeColFXform());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

