/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.pig;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.calrissian.accumulorecipes.commons.collect.TupleStoreIterator;
import org.calrissian.accumulorecipes.commons.hadoop.RecordReaderValueIterator;
import org.calrissian.accumulorecipes.commons.transform.GettableTransform;
import org.calrissian.accumulorecipes.eventstore.hadoop.EventInputFormat;
import org.calrissian.mango.criteria.builder.QueryBuilder;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.types.SimpleTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.uri.support.UriUtils;
import org.joda.time.DateTime;

public class EventLoader
extends LoadFunc
implements Serializable {
    public static final String USAGE = "Usage: event://indexTable/shardTable?user=&pass=&inst=&zk=&start=&end=&auths=[&fields=]";
    protected transient TupleStoreIterator<Event> itr;
    protected final TypeRegistry<String> registry = SimpleTypeEncoders.SIMPLE_TYPES;
    protected final QueryBuilder qb;

    public EventLoader(String query) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkArgument((!query.equals("") ? 1 : 0) != 0);
        try {
            Binding binding = new Binding();
            binding.setVariable("q", (Object)new QueryBuilder());
            GroovyShell shell = new GroovyShell(binding);
            this.qb = (QueryBuilder)shell.evaluate(query);
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error parsing the groovy query string. ");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLocation(String uri, Job job) throws IOException {
        String selectFields;
        Configuration conf = job.getConfiguration();
        if (ConfiguratorBase.isConnectorInfoSet(AccumuloInputFormat.class, (Configuration)job.getConfiguration()).booleanValue()) return;
        String path = uri.substring(uri.indexOf("://") + 3, uri.indexOf("?"));
        String[] indexAndShardTable = StringUtils.splitPreserveAllTokens((String)path, (String)"/");
        if (indexAndShardTable.length != 2) {
            throw new IOException("Path portion of URI must contain the index and shard tables. Usage: event://indexTable/shardTable?user=&pass=&inst=&zk=&start=&end=&auths=[&fields=]");
        }
        if (!uri.startsWith("event")) throw new IOException("Location uri must begin with event://");
        String queryPortion = uri.substring(uri.indexOf("?") + 1, uri.length());
        Multimap queryParams = UriUtils.splitQuery((String)queryPortion);
        String accumuloUser = this.getProp((Multimap<String, String>)queryParams, "user");
        String accumuloPass = this.getProp((Multimap<String, String>)queryParams, "pass");
        String accumuloInst = this.getProp((Multimap<String, String>)queryParams, "inst");
        String zookeepers = this.getProp((Multimap<String, String>)queryParams, "zk");
        if (accumuloUser == null || accumuloPass == null || accumuloInst == null || zookeepers == null) {
            throw new IOException("Some Accumulo connection information is missing. Must supply username, password, instance, and zookeepers. Usage: event://indexTable/shardTable?user=&pass=&inst=&zk=&start=&end=&auths=[&fields=]");
        }
        String startTime = this.getProp((Multimap<String, String>)queryParams, "start");
        String endTime = this.getProp((Multimap<String, String>)queryParams, "end");
        if (startTime == null || endTime == null) {
            throw new IOException("Start and end times are required. Usage: event://indexTable/shardTable?user=&pass=&inst=&zk=&start=&end=&auths=[&fields=]");
        }
        String auths = this.getProp((Multimap<String, String>)queryParams, "auths");
        if (auths == null) {
            auths = "";
        }
        HashSet fields = (selectFields = this.getProp((Multimap<String, String>)queryParams, "fields")) != null ? Sets.newHashSet(Arrays.asList(StringUtils.splitPreserveAllTokens((String)selectFields, (String)","))) : null;
        DateTime startDT = new DateTime((Object)startTime);
        DateTime endDT = new DateTime((Object)endTime);
        EventInputFormat.setZooKeeperInstance((Job)job, (String)accumuloInst, (String)zookeepers);
        try {
            EventInputFormat.setInputInfo(job, accumuloUser, accumuloPass.getBytes(), new Authorizations(auths.getBytes()));
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            EventInputFormat.setQueryInfo(job, startDT.toDate(), endDT.toDate(), this.qb.build());
            if (fields == null) return;
            EventInputFormat.setSelectFields(conf, fields);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getProp(Multimap<String, String> queryParams, String propKey) {
        Collection props = queryParams.get((Object)propKey);
        if (props.size() > 0) {
            return (String)props.iterator().next();
        }
        return null;
    }

    public InputFormat getInputFormat() throws IOException {
        return new EventInputFormat();
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) throws IOException {
        RecordReaderValueIterator rri = new RecordReaderValueIterator(recordReader);
        Iterator xformed = Iterators.transform((Iterator)rri, (Function)new GettableTransform());
        this.itr = new TupleStoreIterator(xformed);
    }

    public Tuple getNext() throws IOException {
        if (!this.itr.hasNext()) {
            return null;
        }
        org.calrissian.mango.domain.Tuple eventTuple = (org.calrissian.mango.domain.Tuple)this.itr.next();
        Tuple t = TupleFactory.getInstance().newTuple();
        t.append((Object)((Event)this.itr.getTopStore()).getId());
        t.append((Object)((Event)this.itr.getTopStore()).getTimestamp());
        t.append((Object)eventTuple.getKey());
        t.append((Object)this.registry.getAlias(eventTuple.getValue()));
        t.append(this.registry.encode(eventTuple.getValue()));
        return t;
    }
}

