/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.iterators.FirstEntryInColumnIterator;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.commons.support.qfd.GlobalIndexValue;
import org.calrissian.accumulorecipes.commons.support.qfd.KeyValueIndex;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.accumulorecipes.eventstore.support.EventCardinalityKey;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.domain.Pair;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.types.TypeRegistry;

public class EventKeyValueIndex
implements KeyValueIndex<Event> {
    private final ShardBuilder<Event> shardBuilder;
    private final TypeRegistry<String> typeRegistry;
    private final String indexTable;
    private final Connector connector;
    private final BatchWriter writer;
    private final StoreConfig config;

    public EventKeyValueIndex(Connector connector, String indexTable, ShardBuilder<Event> shardBuilder, StoreConfig config, TypeRegistry<String> typeRegistry) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        this.shardBuilder = shardBuilder;
        this.typeRegistry = typeRegistry;
        this.indexTable = indexTable;
        this.connector = connector;
        this.config = config;
        if (!connector.tableOperations().exists(indexTable)) {
            connector.tableOperations().create(indexTable);
        }
        this.writer = connector.createBatchWriter(indexTable, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    public void indexKeyValues(Iterable<? extends Event> items) {
        HashMap<String, Long> indexCache = new HashMap<String, Long>();
        HashMap<String, Long> expirationCache = new HashMap<String, Long>();
        for (Event event : items) {
            String shardId = this.shardBuilder.buildShard((TupleStore)event);
            for (Tuple tuple : event.getTuples()) {
                Long curExpiration;
                Long expiration;
                Object[] strings = new String[]{shardId, tuple.getKey(), this.typeRegistry.getAlias(tuple.getValue()), (String)this.typeRegistry.encode(tuple.getValue()), Metadata.Visiblity.getVisibility((Tuple)tuple, (String)"")};
                String cacheKey = StringUtils.join((Object[])strings, (String)"\u0001");
                Long count = (Long)indexCache.get(cacheKey);
                if (count == null) {
                    count = 0L;
                }
                if ((expiration = (Long)expirationCache.get(cacheKey)) == null) {
                    expiration = 0L;
                }
                expiration = (curExpiration = Metadata.Expiration.getExpiration((Map)tuple.getMetadata(), (long)-1L)) == -1L ? Long.valueOf(-1L) : Long.valueOf(Math.max(expiration, curExpiration));
                count = count + 1L;
                indexCache.put(cacheKey, count);
                expirationCache.put(cacheKey, expiration);
            }
        }
        for (Map.Entry entry : indexCache.entrySet()) {
            String[] indexParts = StringUtils.splitPreserveAllTokens((String)((String)entry.getKey()), (String)"\u0001");
            Mutation keyMutation = new Mutation((CharSequence)("k_" + indexParts[1]));
            Mutation valueMutation = new Mutation((CharSequence)("v_" + indexParts[2] + "__" + indexParts[3]));
            Long expiration = (Long)expirationCache.get(entry.getKey());
            Value value = new GlobalIndexValue(((Long)entry.getValue()).longValue(), expiration.longValue()).toValue();
            keyMutation.put(new Text(indexParts[2]), new Text(indexParts[0]), new ColumnVisibility(indexParts[4]), value);
            valueMutation.put(new Text(indexParts[1]), new Text(indexParts[0]), new ColumnVisibility(indexParts[4]), value);
            try {
                this.writer.addMutation(keyMutation);
                this.writer.addMutation(valueMutation);
            }
            catch (MutationsRejectedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public CloseableIterable<Pair<String, String>> uniqueKeys(String prefix, Auths auths) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)auths);
        try {
            BatchScanner scanner = this.connector.createBatchScanner(this.indexTable, auths.getAuths(), this.config.getMaxQueryThreads());
            IteratorSetting setting = new IteratorSetting(15, FirstEntryInColumnIterator.class);
            scanner.addScanIterator(setting);
            scanner.setRanges(Collections.singletonList(new Range((CharSequence)("k_" + prefix + "\u0000"), (CharSequence)("k_" + prefix + "\uffff"))));
            return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), (Function)new Function<Map.Entry<Key, Value>, Pair<String, String>>(){

                public Pair<String, String> apply(Map.Entry<Key, Value> keyValueEntry) {
                    EventCardinalityKey key = new EventCardinalityKey(keyValueEntry.getKey());
                    return new Pair((Object)key.getKey(), (Object)key.getAlias());
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() throws Exception {
        this.writer.flush();
    }

    public void shutdown() throws Exception {
        this.writer.close();
    }
}

