/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.eventstore.support.shard;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.support.qfd.ShardBuilder;
import org.calrissian.accumulorecipes.eventstore.support.shard.EventShardBuilder;
import org.calrissian.mango.domain.event.Event;

public class HourlyShardBuilder
implements ShardBuilder<Event>,
EventShardBuilder {
    protected final Integer numPartitions;
    protected String delimiter = "_";
    protected String dateFormat = "yyyyMMddHH";

    public HourlyShardBuilder(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public String buildShard(Event event) {
        return this.buildShard(event.getTimestamp(), Math.abs(event.getId().hashCode()) % this.numPartitions);
    }

    @Override
    public String buildShard(long timestamp, int partition) {
        int partitionWidth = String.valueOf(this.numPartitions).length();
        Date date = new Date(timestamp);
        return String.format("%s%s%0" + partitionWidth + "d", new SimpleDateFormat(this.dateFormat).format(date), this.delimiter, partition);
    }

    public SortedSet<Text> buildShardsInRange(Date start, Date stop) {
        TreeSet<Text> shards = new TreeSet<Text>();
        int hours = (int)((stop.getTime() - start.getTime()) / 3600000L);
        hours = hours > 0 ? hours : 1;
        for (int i = 0; i < hours; ++i) {
            for (int j = 0; j < this.numPartitions; ++j) {
                shards.add(new Text(this.buildShard(start.getTime(), j)));
            }
            start.setTime(start.getTime() + 3600000L);
        }
        return shards;
    }
}

