/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.examples.blobstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.commons.io.IOUtils;
import org.calrissian.accumulorecipes.blobstore.impl.AccumuloBlobStore;
import org.calrissian.accumulorecipes.commons.domain.Auths;

public class FileStreamExample {
    private static final String SAMPLE_FILE_PATH = "/files/sampleFile.txt";

    public static void main(String[] args) throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + FileStreamExample.class.getName() + " <outputDirectory>");
            System.exit(1);
        }
        String outputDir = args[0];
        MockInstance instance = new MockInstance();
        Connector connector = instance.getConnector("root", "secret".getBytes());
        AccumuloBlobStore blobStore = new AccumuloBlobStore(connector, 1024);
        File file = new File(FileStreamExample.class.getClassLoader().getResource("TestFile.txt").getFile());
        FileInputStream fis = new FileInputStream(file);
        OutputStream storageStream = blobStore.store(SAMPLE_FILE_PATH, "myFiles", file.lastModified(), "ABC");
        IOUtils.copy((InputStream)fis, (OutputStream)storageStream);
        storageStream.flush();
        storageStream.close();
        fis.close();
        System.out.println("File streamed from " + file.getAbsolutePath() + " into Accumulo path " + SAMPLE_FILE_PATH);
        file = new File(outputDir + "/sampleFile.txt");
        FileOutputStream fos = new FileOutputStream(file);
        InputStream retrievalStream = blobStore.get(SAMPLE_FILE_PATH, "myFiles", new Auths("ABC"));
        IOUtils.copy((InputStream)retrievalStream, (OutputStream)fos);
        fos.flush();
        fos.close();
        retrievalStream.close();
        System.out.println("File streamed from /files/sampleFile.txt and written to " + file.getAbsolutePath());
    }
}

