/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.commons.support.TimeUnit;
import org.calrissian.accumulorecipes.commons.support.TimestampUtil;
import org.calrissian.accumulorecipes.featurestore.FeatureStore;
import org.calrissian.accumulorecipes.featurestore.model.Feature;
import org.calrissian.accumulorecipes.featurestore.support.FeatureRegistry;
import org.calrissian.accumulorecipes.featurestore.support.FeatureTransform;
import org.calrissian.accumulorecipes.featurestore.support.Utilities;
import org.calrissian.accumulorecipes.featurestore.support.config.AccumuloFeatureConfig;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;

public class AccumuloFeatureStore
implements FeatureStore {
    public static final String DEFAULT_TABLE_NAME = "features";
    public static final String REVERSE_SUFFIX = "_reverse";
    protected static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(1, 100000L, 100L, 10);
    private final Connector connector;
    private final StoreConfig config;
    private final String tableName;
    private BatchWriter groupWriter;
    private BatchWriter typeWriter;
    private boolean isInitialized = false;
    protected final FeatureRegistry registry;

    public AccumuloFeatureStore(Connector connector) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        this(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG, FeatureRegistry.BASE_FEATURES);
    }

    public AccumuloFeatureStore(Connector connector, String tableName, StoreConfig config, FeatureRegistry featureRegistry) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)config);
        this.connector = connector;
        this.tableName = tableName;
        this.config = config;
        this.registry = featureRegistry;
    }

    public void initialize() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        this.createTable(this.tableName);
        this.createTable(this.tableName + REVERSE_SUFFIX);
        this.groupWriter = this.connector.createBatchWriter(this.tableName, this.config.getMaxMemory(), this.config.getMaxLatency(), this.config.getMaxWriteThreads());
        this.typeWriter = this.connector.createBatchWriter(this.tableName + REVERSE_SUFFIX, this.config.getMaxMemory(), this.config.getMaxLatency(), this.config.getMaxWriteThreads());
        this.isInitialized = true;
    }

    private void createTable(String tableName) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        int priority = 15;
        if (!this.connector.tableOperations().exists(tableName)) {
            this.connector.tableOperations().create(tableName, false);
            for (AccumuloFeatureConfig featureConfig : this.registry.getConfigs()) {
                List<IteratorSetting> settings = featureConfig.buildIterators(priority);
                int numSettings = 0;
                for (IteratorSetting setting : settings) {
                    ++numSettings;
                    this.connector.tableOperations().attachIterator(tableName, setting);
                }
                priority += numSettings;
            }
        }
    }

    protected ScannerBase metricScanner(Date start, Date end, String group, String type, String name, TimeUnit timeUnit, AccumuloFeatureConfig featureConfig, Auths auths) {
        Preconditions.checkNotNull((Object)type);
        return this.metricScanner(start, end, group, Collections.singleton(type), name, timeUnit, featureConfig, auths);
    }

    protected ScannerBase metricScanner(Date start, Date end, String group, Set<String> types, String name, TimeUnit timeUnit, AccumuloFeatureConfig featureConfig, Auths auths) {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull(types);
        Preconditions.checkArgument((types.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)auths);
        try {
            group = StringUtils.defaultString((String)group);
            timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
            BatchScanner scanner = this.connector.createBatchScanner(this.tableName + REVERSE_SUFFIX, auths.getAuths(), this.config.getMaxQueryThreads());
            HashSet<Range> ranges = new HashSet<Range>();
            for (String type : types) {
                ranges.add(new Range((CharSequence)Utilities.combine(type, TimestampUtil.generateTimestamp((long)end.getTime(), (TimeUnit)timeUnit)), (CharSequence)Utilities.combine(type, TimestampUtil.generateTimestamp((long)start.getTime(), (TimeUnit)timeUnit))));
            }
            scanner.setRanges(ranges);
            if (name != null) {
                scanner.fetchColumn(new Text(Utilities.combine(featureConfig.featureName(), timeUnit.toString())), new Text(Utilities.combine(group, name)));
            } else {
                scanner.fetchColumnFamily(new Text(Utilities.combine(featureConfig.featureName(), timeUnit.toString())));
                String cqRegex = null;
                cqRegex = Utilities.combine(group, "(.*)");
                IteratorSetting regexIterator = new IteratorSetting(14, "regex", RegExFilter.class);
                RegExFilter.setRegexs((IteratorSetting)regexIterator, null, null, (String)cqRegex, null, (boolean)false);
                scanner.addScanIterator(regexIterator);
            }
            return scanner;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() throws MutationsRejectedException {
        this.groupWriter.close();
    }

    @Override
    public void save(Iterable<? extends Feature> featureData) {
        this.save(featureData, Arrays.asList(TimeUnit.values()));
    }

    @Override
    public void save(Iterable<? extends Feature> featureData, Iterable<TimeUnit> timeUnits) {
        if (!this.isInitialized) {
            throw new RuntimeException("Please called initialize() on the store first");
        }
        try {
            for (Feature feature : featureData) {
                AccumuloFeatureConfig featureConfig = this.registry.transformForClass(feature.getClass());
                if (featureConfig == null) {
                    throw new RuntimeException("Skipping unknown model type: " + feature.getClass());
                }
                String group = StringUtils.defaultString((String)feature.getGroup());
                String type = StringUtils.defaultString((String)feature.getType());
                String name = StringUtils.defaultString((String)feature.getName());
                ColumnVisibility visibility = new ColumnVisibility(StringUtils.defaultString((String)feature.getVisibility()));
                for (TimeUnit timeUnit : timeUnits) {
                    String timestamp = TimestampUtil.generateTimestamp((long)feature.getTimestamp(), (TimeUnit)timeUnit);
                    Mutation group_mutation = new Mutation((CharSequence)Utilities.combine(group, timestamp));
                    Mutation type_mutation = new Mutation((CharSequence)Utilities.combine(type, timestamp));
                    group_mutation.put((CharSequence)Utilities.combine(featureConfig.featureName(), timeUnit.toString()), (CharSequence)Utilities.combine(type, name), visibility, feature.getTimestamp(), featureConfig.buildValue(feature));
                    type_mutation.put((CharSequence)Utilities.combine(featureConfig.featureName(), timeUnit.toString()), (CharSequence)Utilities.combine(group, name), visibility, feature.getTimestamp(), featureConfig.buildValue(feature));
                    this.groupWriter.addMutation(group_mutation);
                    this.typeWriter.addMutation(type_mutation);
                }
            }
            this.groupWriter.flush();
            this.typeWriter.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Feature> CloseableIterable<T> query(Date start, Date end, String group, String type, String name, TimeUnit timeUnit, Class<T> featureType, Auths auths) {
        return this.query(start, end, group, Collections.singleton(type), name, timeUnit, featureType, auths);
    }

    @Override
    public <T extends Feature> CloseableIterable<T> query(Date start, Date end, String group, Set<String> types, String name, TimeUnit timeUnit, Class<T> featureType, Auths auths) {
        if (!this.isInitialized) {
            throw new RuntimeException("Please call initialize() on the store first.");
        }
        final AccumuloFeatureConfig featureConfig = this.registry.transformForClass(featureType);
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)this.metricScanner(start, end, group, types, name, timeUnit, featureConfig, auths)), (Function)new FeatureTransform<T>(timeUnit){

            @Override
            protected T transform(long timestamp, String group, String type, String name, String visibility, Value value) {
                return (Feature)featureConfig.buildFeatureFromValue(timestamp, group, type, name, visibility, value);
            }
        });
    }
}

