/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public abstract class Feature<T extends Writable>
implements Writable {
    protected long timestamp;
    protected String group;
    protected String type;
    protected String name;
    protected String visibility;
    protected T vector;

    protected Feature(long timestamp, String group, String type, String name, String visibility, T vector) {
        this.timestamp = timestamp;
        this.group = group;
        this.type = type;
        this.name = name;
        this.visibility = visibility;
        this.vector = vector;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public T getVector() {
        return this.vector;
    }

    protected abstract T buildVector(DataInput var1);

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.getTimestamp());
        dataOutput.writeUTF(this.getGroup());
        dataOutput.writeUTF(this.getType());
        dataOutput.writeUTF(this.getName());
        dataOutput.writeUTF(this.getVisibility());
        this.getVector().write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.timestamp = dataInput.readLong();
        this.group = dataInput.readUTF();
        this.type = dataInput.readUTF();
        this.name = dataInput.readUTF();
        this.visibility = dataInput.readUTF();
        this.vector = this.buildVector(dataInput);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature that = (Feature)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.vector != null ? !this.vector.equals(that.vector) : that.vector != null) {
            return false;
        }
        return !(this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        result = 31 * result + (this.vector != null ? this.vector.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Feature{timestamp=" + this.timestamp + ", group='" + this.group + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + ", vector=" + this.vector + '}';
    }
}

