/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.hadoop.io.Writable;

public class Metric
implements Writable {
    private long min;
    private long max;
    private long sum;
    private long count;
    private BigInteger sumSquare;

    public Metric() {
    }

    public Metric(long value) {
        this.min = value;
        this.max = value;
        this.sum = value;
        this.count = 1L;
        this.sumSquare = BigInteger.valueOf(value).multiply(BigInteger.valueOf(value));
    }

    public Metric(long min, long max, long sum, long count, BigInteger sumSquare) {
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
        this.sumSquare = sumSquare;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public BigInteger getSumSquare() {
        return this.sumSquare;
    }

    public double getMean() {
        if (this.count < 1L) {
            return 0.0;
        }
        return (double)this.sum / (double)this.count;
    }

    public double getVariance() {
        BigDecimal sumSquare = new BigDecimal(this.sumSquare);
        if (this.count < 2L) {
            return 0.0;
        }
        BigDecimal sumSquareDivideByCount = sumSquare.divide(BigDecimal.valueOf(this.count), 15, RoundingMode.FLOOR);
        return sumSquareDivideByCount.subtract(new BigDecimal(this.getMean() * this.getMean())).doubleValue();
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.min);
        dataOutput.writeLong(this.max);
        dataOutput.writeLong(this.sum);
        dataOutput.writeLong(this.count);
        dataOutput.writeUTF(this.sumSquare.toString());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.min = dataInput.readLong();
        this.max = dataInput.readLong();
        this.sum = dataInput.readLong();
        this.count = dataInput.readLong();
        this.sumSquare = new BigInteger(dataInput.readUTF());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric that = (Metric)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.max != that.max) {
            return false;
        }
        if (this.min != that.min) {
            return false;
        }
        if (this.sum != that.sum) {
            return false;
        }
        return !(this.sumSquare != null ? !this.sumSquare.equals(that.sumSquare) : that.sumSquare != null);
    }

    public int hashCode() {
        int result = (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.sum ^ this.sum >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (this.sumSquare != null ? this.sumSquare.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Metric{min=" + this.min + ", max=" + this.max + ", sum=" + this.sum + ", count=" + this.count + ", sumSquare=" + this.sumSquare + '}';
    }
}

