/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.pig;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.calrissian.accumulorecipes.commons.support.TimeUnit;
import org.calrissian.accumulorecipes.featurestore.hadoop.FeaturesInputFormat;
import org.calrissian.accumulorecipes.featurestore.model.Feature;
import org.calrissian.accumulorecipes.featurestore.model.Metric;
import org.calrissian.accumulorecipes.featurestore.model.MetricFeature;
import org.calrissian.mango.types.SimpleTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.uri.support.UriUtils;
import org.joda.time.DateTime;

public class MetricFeatureLoader
extends LoadFunc {
    public static final String USAGE = "Usage: metrics://tablePrefix?user=&pass=&inst=&zk=&timeUnit=&start=&end=&auths=&group=[&type=&name=]";
    protected TypeRegistry<String> registry = SimpleTypeEncoders.SIMPLE_TYPES;
    protected RecordReader<Key, ? extends Feature> reader;
    protected TimeUnit timeUnit;

    public void setLocation(String uri, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        String path = uri.substring(uri.indexOf("://") + 3, uri.indexOf("?"));
        String[] indexAndShardTable = StringUtils.splitPreserveAllTokens((String)path, (String)"/");
        if (indexAndShardTable.length != 1) {
            throw new IOException("Path portion of URI must contain the metric table prefix Usage: metrics://tablePrefix?user=&pass=&inst=&zk=&timeUnit=&start=&end=&auths=&group=[&type=&name=]");
        }
        if (uri.startsWith("metrics")) {
            String queryPortion = uri.substring(uri.indexOf("?") + 1, uri.length());
            Multimap queryParams = UriUtils.splitQuery((String)queryPortion);
            String accumuloUser = this.getProp((Multimap<String, String>)queryParams, "user");
            String accumuloPass = this.getProp((Multimap<String, String>)queryParams, "pass");
            String accumuloInst = this.getProp((Multimap<String, String>)queryParams, "inst");
            String zookeepers = this.getProp((Multimap<String, String>)queryParams, "zk");
            if (accumuloUser == null || accumuloPass == null || accumuloInst == null || zookeepers == null) {
                throw new IOException("Some Accumulo connection information is missing. Must supply username, password, instance, and zookeepers. Usage: metrics://tablePrefix?user=&pass=&inst=&zk=&timeUnit=&start=&end=&auths=&group=[&type=&name=]");
            }
            String timeUnitStr = this.getProp((Multimap<String, String>)queryParams, "timeUnit");
            if (timeUnitStr == null) {
                throw new IOException("A valid TimeUnit must be supplied. Usage: metrics://tablePrefix?user=&pass=&inst=&zk=&timeUnit=&start=&end=&auths=&group=[&type=&name=]");
            }
            this.timeUnit = TimeUnit.valueOf((String)timeUnitStr.toUpperCase());
            String group = this.getProp((Multimap<String, String>)queryParams, "group");
            String type = this.getProp((Multimap<String, String>)queryParams, "type");
            String name = this.getProp((Multimap<String, String>)queryParams, "name");
            String startTime = this.getProp((Multimap<String, String>)queryParams, "start");
            String endTime = this.getProp((Multimap<String, String>)queryParams, "end");
            if (startTime == null || endTime == null) {
                throw new IOException("Start and end times are required. Usage: metrics://tablePrefix?user=&pass=&inst=&zk=&timeUnit=&start=&end=&auths=&group=[&type=&name=]");
            }
            String auths = this.getProp((Multimap<String, String>)queryParams, "auths");
            if (auths == null) {
                auths = "";
            }
            DateTime startDT = DateTime.parse((String)startTime);
            DateTime endDT = DateTime.parse((String)endTime);
            FeaturesInputFormat.setZooKeeperInstance((Configuration)conf, (String)accumuloInst, (String)zookeepers);
            FeaturesInputFormat.setInputInfo(conf, accumuloUser, accumuloPass.getBytes(), new Authorizations(auths.getBytes()));
            try {
                FeaturesInputFormat.setQueryInfo(conf, startDT.toDate(), endDT.toDate(), this.timeUnit, group, type, name, MetricFeature.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IOException("Location uri must begin with metrics://");
        }
    }

    private String getProp(Multimap<String, String> queryParams, String propKey) {
        Collection props = queryParams.get((Object)propKey);
        if (props.size() > 0) {
            return (String)props.iterator().next();
        }
        return null;
    }

    public InputFormat getInputFormat() throws IOException {
        return new FeaturesInputFormat();
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) throws IOException {
        this.reader = recordReader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        try {
            MetricFeature metric = (MetricFeature)this.reader.getCurrentValue();
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append((Object)metric.getTimestamp());
            t.append((Object)this.timeUnit.toString());
            t.append((Object)metric.getGroup());
            t.append((Object)metric.getType());
            t.append((Object)metric.getName());
            t.append((Object)metric.getVisibility());
            t.append((Object)((Metric)metric.getVector()).getSum());
            return t;
        }
        catch (InterruptedException e) {
            throw new IOException();
        }
    }
}

